/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.nested;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.NestedRouter;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringMessageUtils;

public class NestedInvocationHandler
implements InvocationHandler {
    public static final String DEFAULT_METHOD_NAME_TOKEN = "default";
    protected static Log logger = LogFactory.getLog(NestedInvocationHandler.class);
    protected Map routers = new ConcurrentHashMap();

    protected NestedInvocationHandler(NestedRouter router) {
        this.addRouterForInterface(router);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRouterForInterface(NestedRouter router) {
        if (router.getMethod() == null) {
            if (this.routers.size() != 0) throw new IllegalArgumentException(CoreMessages.mustSetMethodNamesOnBinding().getMessage());
            this.routers.put(DEFAULT_METHOD_NAME_TOKEN, router);
            return;
        } else {
            this.routers.put(router.getMethod(), router);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        DefaultMuleMessage message = new DefaultMuleMessage(args);
        NestedRouter router = (NestedRouter)this.routers.get(method.getName());
        if (router == null) {
            router = (NestedRouter)this.routers.get(DEFAULT_METHOD_NAME_TOKEN);
        }
        if (router == null) {
            throw new IllegalArgumentException(CoreMessages.cannotFindBindingForMethod(method.getName()).toString());
        }
        MuleEvent currentEvent = RequestContext.getEvent();
        MuleMessage reply = router.route(message, currentEvent.getSession(), router.getEndpoint().isSynchronous());
        if (reply != null) {
            if (reply.getExceptionPayload() != null) {
                throw reply.getExceptionPayload().getException();
            }
            return reply.getPayload();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NestedInvocation");
        sb.append("{routers='").append(StringMessageUtils.toString(this.routers));
        sb.append('}');
        return sb.toString();
    }
}

