/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import java.util.Date;
import org.mule.RequestContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.message.BaseMessage;

public class ExceptionMessage
extends BaseMessage {
    private static final long serialVersionUID = -538516243574950621L;
    private Throwable exception;
    private String componentName;
    private EndpointURI endpointUri;
    private Date timeStamp;

    public ExceptionMessage(Object message, Throwable exception, String componentName, EndpointURI endpointUri) {
        super(message);
        this.exception = exception;
        this.timeStamp = new Date();
        this.componentName = componentName;
        this.endpointUri = endpointUri;
        MuleEventContext ctx = RequestContext.getEventContext();
        if (ctx != null) {
            MuleMessage msg = ctx.getMessage();
            for (String propertyKey : msg.getPropertyNames()) {
                this.setProperty(propertyKey, msg.getProperty(propertyKey));
            }
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public EndpointURI getEndpoint() {
        return this.endpointUri;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "ExceptionMessage{message=" + this.message + ", context=" + this.context + "exception=" + this.exception + ", componentName='" + this.componentName + "'" + ", endpointUri=" + this.endpointUri + ", timeStamp=" + this.timeStamp + "}";
    }
}

