/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.lifecycle.phases.NotInLifecyclePhase;
import org.mule.util.StringMessageUtils;

public class GenericLifecycleManager
implements LifecycleManager {
    protected final transient Log logger = LogFactory.getLog(GenericLifecycleManager.class);
    protected static NotInLifecyclePhase notInLifecyclePhase = new NotInLifecyclePhase();
    protected String currentPhase = notInLifecyclePhase.getName();
    protected String executingPhase = null;
    protected ListOrderedSet lifecycles = new ListOrderedSet();
    protected Map index = new HashMap(6);
    protected Set completedPhases = new HashSet(6);

    public Set getLifecycles() {
        return this.lifecycles;
    }

    public void setLifecycles(Set lifecycles) {
        for (LifecyclePhase phase : lifecycles) {
            this.registerLifecycle(phase);
        }
    }

    public void registerLifecycle(LifecyclePhase lci) {
        this.index.put(lci.getName(), new Integer(this.lifecycles.size()));
        this.lifecycles.add((Object)lci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePhase(MuleContext muleContext, String phase) throws MuleException {
        if (this.currentPhase.equalsIgnoreCase(phase)) {
            this.logger.debug((Object)("Already in lifecycle phase: " + phase));
            return;
        }
        Integer phaseIndex = (Integer)this.index.get(phase);
        if (phaseIndex == null) {
            throw new IllegalArgumentException("No lifeccycle phase registered with name: " + phase);
        }
        try {
            this.setExecutingPhase(phase);
            LifecyclePhase li = (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
            li.fireLifecycle(muleContext, this.currentPhase);
            this.setCurrentPhase(li);
        }
        finally {
            this.setExecutingPhase(null);
        }
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public String getExecutingPhase() {
        return this.executingPhase;
    }

    protected synchronized void setCurrentPhase(LifecyclePhase phase) {
        this.completedPhases.add(phase.getName());
        this.completedPhases.remove(phase.getOppositeLifecyclePhase());
        this.currentPhase = phase.getName();
    }

    protected synchronized void setExecutingPhase(String phase) {
        this.executingPhase = phase;
    }

    public void reset() {
        this.setExecutingPhase(null);
        this.completedPhases.clear();
        this.setCurrentPhase(notInLifecyclePhase);
    }

    public boolean isPhaseComplete(String phaseName) {
        return this.completedPhases.contains(phaseName);
    }

    public void applyLifecycle(MuleContext muleContext, Object object) throws MuleException {
        LifecyclePhase lcp;
        Integer phaseIndex;
        for (String phase : this.completedPhases) {
            phaseIndex = (Integer)this.index.get(phase);
            lcp = (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
            lcp.applyLifecycle(object);
        }
        if (this.getExecutingPhase() != null) {
            phaseIndex = (Integer)this.index.get(this.getExecutingPhase());
            lcp = (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
            lcp.applyLifecycle(object);
        }
    }

    public void checkPhase(String name) throws IllegalStateException {
        if (this.completedPhases.contains(name)) {
            throw new IllegalStateException("Phase '" + name + "' has already been executed");
        }
        if (name.equalsIgnoreCase(this.executingPhase)) {
            throw new IllegalStateException("Phase '" + name + "' is already currently being executed");
        }
        if (this.executingPhase != null) {
            throw new IllegalStateException("Currently executing lifecycle phase: " + this.executingPhase);
        }
        Integer phaseIndex = (Integer)this.index.get(name);
        if (phaseIndex == null) {
            throw new IllegalStateException("Phase does not exist: " + name);
        }
        if (NotInLifecyclePhase.PHASE_NAME.equals(this.currentPhase)) {
            if (phaseIndex > 0) {
                throw new IllegalStateException("The first lifecycle phase has to be called before the '" + name + "' phase");
            }
        } else {
            LifecyclePhase phase = (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
            if (!phase.isPhaseSupported(this.currentPhase)) {
                throw new IllegalStateException("Lifecycle phase: " + this.currentPhase + " does not support current phase: " + name + ". Phases supported are: " + StringMessageUtils.toString(phase.getSupportedPhases()));
            }
        }
    }
}

