/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.VoidResult;
import org.mule.api.DefaultMuleException;
import org.mule.api.Invocation;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleAdapter;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.routing.NestedRouter;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.api.service.ServiceException;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.model.resolvers.NoSatisfiableMethodsException;
import org.mule.model.resolvers.TooManySatisfiableMethodsException;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.transformer.TransformerTemplate;
import org.mule.util.ClassUtils;

public class DefaultLifecycleAdapter
implements LifecycleAdapter {
    protected static final Log logger = LogFactory.getLog(DefaultLifecycleAdapter.class);
    private Object pojoService;
    private Service service;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;
    private EntryPointResolverSet entryPointResolver;

    public DefaultLifecycleAdapter(Object pojoService, Service service) throws MuleException {
        this(pojoService, service, new LegacyEntryPointResolverSet());
    }

    public DefaultLifecycleAdapter(Object pojoService, Service service, EntryPointResolverSet epResolver) throws MuleException {
        this.initialise(pojoService, service, epResolver);
    }

    protected void initialise(Object pojoService, Service service, EntryPointResolverSet entryPointResolver) throws MuleException {
        if (pojoService == null) {
            throw new IllegalArgumentException("POJO Service cannot be null");
        }
        if (entryPointResolver == null) {
            entryPointResolver = new LegacyEntryPointResolverSet();
        }
        this.pojoService = pojoService;
        this.service = service;
        this.entryPointResolver = entryPointResolver;
        this.isStartable = Startable.class.isInstance(service);
        this.isStoppable = Stoppable.class.isInstance(service);
        this.isDisposable = Disposable.class.isInstance(service);
        if (pojoService instanceof ServiceAware) {
            ((ServiceAware)pojoService).setService(service);
        }
        this.configureNestedRouter();
    }

    public void start() throws MuleException {
        if (this.isStartable) {
            try {
                this.service.start();
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStart("UMO Service: " + this.service.getName()), (Throwable)e);
            }
        }
        this.started = true;
    }

    public void stop() throws MuleException {
        if (this.isStoppable) {
            try {
                this.service.stop();
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStop("UMO Service: " + this.service.getName()), (Throwable)e);
            }
        }
        this.started = false;
    }

    public void dispose() {
        if (this.isDisposable) {
            try {
                this.service.dispose();
            }
            catch (Exception e) {
                logger.error((Object)("failed to dispose: " + this.service.getName()), (Throwable)e);
            }
        }
        this.disposed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void handleException(Object message, Exception e) {
        this.service.getExceptionListener().exceptionThrown(e);
    }

    public MuleMessage intercept(Invocation invocation) throws MuleException {
        Object result;
        MuleEvent event = RequestContext.getEvent();
        try {
            result = this.service.getEntryPointResolverSet() != null ? this.service.getEntryPointResolverSet().invoke(this.pojoService, RequestContext.getEventContext()) : this.entryPointResolver.invoke(this.pojoService, RequestContext.getEventContext());
        }
        catch (Exception e) {
            throw new ServiceException(RequestContext.getEventContext().getMessage(), this.service, (Throwable)e);
        }
        MuleMessage resultMessage = null;
        if (result instanceof VoidResult) {
            event.transformMessage();
            resultMessage = event.getMessage();
        } else if (result != null) {
            if (result instanceof MuleMessage) {
                resultMessage = (MuleMessage)result;
            } else {
                event.getMessage().applyTransformers(Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
                resultMessage = event.getMessage();
            }
        }
        return resultMessage;
    }

    public void initialise() throws InitialisationException {
        if (Initialisable.class.isInstance(this.service)) {
            this.service.initialise();
        }
    }

    protected void configureNestedRouter() throws MuleException {
        if (this.service.getNestedRouter() != null) {
            HashMap bindings = new HashMap();
            for (NestedRouter nestedRouter : this.service.getNestedRouter().getRouters()) {
                Object proxy = bindings.get(nestedRouter.getInterface());
                if (proxy == null) {
                    proxy = nestedRouter.createProxy(this.pojoService);
                    bindings.put(nestedRouter.getInterface(), proxy);
                    List methods = ClassUtils.getSatisfiableMethods(this.pojoService.getClass(), new Class[]{nestedRouter.getInterface()}, true, false, null);
                    if (methods.size() != 1) {
                        if (methods.size() > 1) {
                            throw new TooManySatisfiableMethodsException(this.pojoService.getClass(), new Class[]{nestedRouter.getInterface()});
                        }
                        throw new NoSatisfiableMethodsException(this.pojoService.getClass(), new Class[]{nestedRouter.getInterface()});
                    }
                    Method setterMethod = (Method)methods.get(0);
                    try {
                        setterMethod.invoke(this.pojoService, proxy);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.failedToSetProxyOnService(nestedRouter, this.pojoService.getClass()), (Throwable)e, this);
                    }
                }
                NestedInvocationHandler handler = (NestedInvocationHandler)Proxy.getInvocationHandler(proxy);
                handler.addRouterForInterface(nestedRouter);
            }
        }
    }

    public Service getService() {
        return this.service;
    }
}

