/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;

public class OptimisedNotificationHandler
implements ServerNotificationHandler {
    private ServerNotificationHandler delegate;
    private Class type;
    private boolean dynamic = false;
    private boolean enabled = false;

    public OptimisedNotificationHandler(ServerNotificationHandler delegate, Class type) {
        this.delegate = delegate;
        this.type = type;
        this.dynamic = delegate.isNotificationDynamic();
        this.enabled = delegate.isNotificationEnabled(type);
    }

    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    public boolean isNotificationEnabled(Class notfnClass) {
        if (!this.dynamic && this.type.isAssignableFrom(notfnClass)) {
            return this.enabled;
        }
        return this.delegate.isNotificationEnabled(notfnClass);
    }

    public void fireNotification(ServerNotification notification) {
        if (this.isNotificationEnabled(notification.getClass())) {
            this.delegate.fireNotification(notification);
        }
    }
}

