/*
 * Decompiled with CFR 0.152.
 */
package org.mule.container;

import java.io.Reader;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.context.ContainerContext;
import org.mule.api.context.ContainerException;
import org.mule.api.context.ObjectNotFoundException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.container.ContainerKeyPair;
import org.mule.container.MuleContainerContext;

public class MultiContainerContext
implements ContainerContext {
    protected static final Log logger = LogFactory.getLog(MultiContainerContext.class);
    private String name = "multi";
    private TreeMap containers = new TreeMap();

    public MultiContainerContext() {
        this.addContainer(new MuleContainerContext());
    }

    public void setName(String name) {
    }

    public String getName() {
        return this.name;
    }

    public void addContainer(ContainerContext container) {
        if (this.containers.containsKey(container.getName())) {
            throw new IllegalArgumentException(CoreMessages.containerAlreadyRegistered(container.getName()).toString());
        }
        this.containers.put(container.getName(), container);
    }

    public ContainerContext removeContainer(String name) {
        return (ContainerContext)this.containers.remove(name);
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        ContainerKeyPair realKey = null;
        StringBuffer cause = new StringBuffer();
        Throwable finalCause = null;
        realKey = key instanceof String ? new ContainerKeyPair(null, key) : (ContainerKeyPair)key;
        if (realKey == null) {
            throw new ObjectNotFoundException(null);
        }
        Object component = null;
        if (realKey.getContainerName() != null) {
            ContainerContext container = (ContainerContext)this.containers.get(realKey.getContainerName());
            if (container != null) {
                return container.getComponent(realKey);
            }
            throw new ObjectNotFoundException("Container: " + realKey.getContainerName());
        }
        for (ContainerContext container : this.containers.values()) {
            try {
                component = container.getComponent(realKey);
            }
            catch (ObjectNotFoundException e) {
                if (e.getCause() != null) {
                    finalCause = e.getCause();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Object: '" + realKey + "' not found in container: " + container.getName()));
                    }
                } else {
                    finalCause = e;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Object: '" + realKey + "' not found in container: " + container.getName()));
                    }
                }
                if (cause.length() > 0) {
                    cause.append("; ");
                }
                cause.append(finalCause.toString());
            }
            if (component == null) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("Object: '" + realKey + "' found in container: " + container.getName()));
            break;
        }
        if (component == null) {
            if (realKey.isRequired()) {
                throw new ObjectNotFoundException(realKey.toString() + " " + cause, finalCause);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Service reference not found: " + realKey.toFullString()));
                return null;
            }
        }
        return component;
    }

    public void configure(Reader configuration, String doctype, String encoding) throws ContainerException {
    }

    public void dispose() {
        for (ContainerContext container : this.containers.values()) {
            container.dispose();
        }
        this.containers.clear();
        this.containers = null;
    }

    public void initialise() throws InitialisationException {
    }
}

