/*
 * Decompiled with CFR 0.152.
 */
package org.mule.container;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.context.ContainerContext;
import org.mule.api.context.ContainerException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.util.ChainedReader;
import org.mule.util.SystemUtils;

public abstract class AbstractContainerContext
implements ContainerContext,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String name;
    protected MuleContext muleContext;

    protected AbstractContainerContext(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initialise() throws InitialisationException {
    }

    public final void doInitialise(MuleContext muleContext) throws InitialisationException {
    }

    public void dispose() {
    }

    public final void configure(Reader configuration, String doctype, String encoding) throws ContainerException {
        String decl = this.getXmlDeclaration(encoding);
        this.logger.debug((Object)("Using Xml declaration: " + decl));
        if (doctype == null) {
            doctype = this.getDefaultDocType();
        }
        if (doctype != null) {
            if (!doctype.startsWith("<!DOCTYPE")) {
                doctype = "<!DOCTYPE " + doctype + ">";
            }
            this.logger.info((Object)("Using doctype: " + doctype));
        } else {
            doctype = "";
        }
        StringReader declaration = new StringReader(decl + SystemUtils.LINE_SEPARATOR + doctype);
        ChainedReader reader = new ChainedReader(declaration, configuration);
        this.configure(reader);
    }

    protected String getXmlDeclaration(String encoding) {
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return "<?xml version=\"1.0\" encoding=\"" + encoding.toUpperCase() + "\"?>";
    }

    protected String getDefaultDocType() {
        return null;
    }

    protected String getDefaultEncoding() {
        return RegistryContext.getConfiguration().getDefaultEncoding();
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public abstract void configure(Reader var1) throws ContainerException;
}

