/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.builders.AutoConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public abstract class AbstractResourceConfigurationBuilder
extends AbstractConfigurationBuilder {
    protected static final Log logger = LogFactory.getLog(AutoConfigurationBuilder.class);
    protected String[] configResources;

    public AbstractResourceConfigurationBuilder(String configResources) {
        this.configResources = StringUtils.splitAndTrim(configResources, ",; ");
    }

    public AbstractResourceConfigurationBuilder(String[] configResources) {
        this.configResources = configResources;
    }

    public void configure(MuleContext muleContext) throws ConfigurationException {
        if (this.configResources == null) {
            throw new ConfigurationException(CoreMessages.objectIsNull("Configuration Resource"));
        }
        super.configure(muleContext);
        logger.info((Object)CoreMessages.configurationBuilderSuccess((ConfigurationBuilder)this, this.createConfigResourcesString()));
        muleContext.getRegistry().getConfiguration().setConfigResources(this.configResources);
    }

    protected InputStream loadConfig(String configResource) throws ConfigurationException {
        InputStream is;
        try {
            is = IOUtils.getResourceAsStream(configResource, this.getClass());
        }
        catch (IOException e) {
            throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath(configResource), (Throwable)e);
        }
        if (is != null) {
            return is;
        }
        throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath(configResource));
    }

    protected String createConfigResourcesString() {
        StringBuffer configResourcesString = new StringBuffer();
        configResourcesString.append("[");
        for (int i = 0; i < this.configResources.length; ++i) {
            configResourcesString.append(this.configResources[i]);
            if (i >= this.configResources.length - 1) continue;
            configResourcesString.append(", ");
        }
        configResourcesString.append("]");
        return configResourcesString.toString();
    }
}

