/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.transformer;

import java.util.List;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.Message;
import org.mule.transformer.TransformerUtils;

public class TransformerException
extends EndpointException {
    private static final long serialVersionUID = 2943589828020763649L;
    private transient Transformer transformer;

    public TransformerException(Message message, Transformer transformer) {
        super(message);
        this.transformer = transformer;
        this.addInfo("Transformer", transformer.toString());
    }

    public TransformerException(Message message, List transformers) {
        super(message);
        this.transformer = TransformerUtils.firstOrNull(transformers);
        this.addInfo("Transformer", TransformerUtils.toString(transformers));
    }

    public TransformerException(Message message, Transformer transformer, Throwable cause) {
        super(message, cause);
        this.transformer = transformer;
        this.addInfo("Transformer", transformer.toString());
    }

    public TransformerException(Message message, List transformers, Throwable cause) {
        super(message, cause);
        this.transformer = TransformerUtils.firstOrNull(transformers);
        this.addInfo("Transformer", TransformerUtils.toString(transformers));
    }

    public TransformerException(Transformer transformer, Throwable cause) {
        super(cause);
        this.transformer = transformer;
        this.addInfo("Transformer", transformer == null ? "null" : transformer.toString());
    }

    public TransformerException(List transformers, Throwable cause) {
        super(cause);
        this.transformer = TransformerUtils.firstOrNull(transformers);
        this.addInfo("Transformer", TransformerUtils.toString(transformers));
    }

    public TransformerException(Message message, Throwable cause) {
        super(message, cause);
    }

    public TransformerException(Message message) {
        super(message);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

