/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.service;

import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.service.Service;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class ServiceException
extends MessagingException {
    private static final long serialVersionUID = 56178344205041599L;
    private final transient Service service;

    public ServiceException(Message message, MuleMessage umoMessage, Service service) {
        super(ServiceException.generateMessage(message, service), umoMessage);
        this.service = service;
    }

    public ServiceException(Message message, MuleMessage umoMessage, Service service, Throwable cause) {
        super(ServiceException.generateMessage(message, service), umoMessage, cause);
        this.service = service;
    }

    public ServiceException(MuleMessage umoMessage, Service service, Throwable cause) {
        super(ServiceException.generateMessage(null, service), umoMessage, cause);
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    private static Message generateMessage(Message previousMessage, Service service) {
        Message returnMessage = CoreMessages.componentCausedErrorIs(service);
        if (previousMessage != null) {
            previousMessage.setNextMessage(returnMessage);
            return previousMessage;
        }
        return returnMessage;
    }
}

