/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.security;

import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class UnauthorisedException
extends SecurityException {
    private static final long serialVersionUID = -6664384216189042672L;

    public UnauthorisedException(Message message) {
        super(message, RequestContext.getEventContext().getMessage());
    }

    public UnauthorisedException(Message message, Throwable cause) {
        super(message, RequestContext.getEventContext().getMessage(), cause);
    }

    public UnauthorisedException(Message message, MuleMessage umoMessage) {
        super(message, umoMessage);
    }

    public UnauthorisedException(Message message, MuleMessage umoMessage, Throwable cause) {
        super(message, umoMessage, cause);
    }

    public UnauthorisedException(MuleMessage umoMessage, SecurityContext context, ImmutableEndpoint endpoint, EndpointSecurityFilter filter) {
        super(UnauthorisedException.constructMessage(context, endpoint, filter), umoMessage);
    }

    private static Message constructMessage(SecurityContext context, ImmutableEndpoint endpoint, EndpointSecurityFilter filter) {
        Message m = null;
        m = context == null ? CoreMessages.authSetButNoContext(filter.getClass().getName()) : CoreMessages.authFailedForUser(context.getAuthentication().getPrincipal());
        m.setNextMessage(CoreMessages.authDeniedOnEndpoint(endpoint.getEndpointURI()));
        return m;
    }
}

