/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.context.notification;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.EventObject;
import java.util.Map;
import org.mule.RegistryContext;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.util.ClassUtils;

public abstract class ServerNotification
extends EventObject {
    public static final int NO_ACTION_ID = Integer.MIN_VALUE;
    public static final String NO_ACTION_NAME = "none";
    public static final String TYPE_INFO = "info";
    public static final String TYPE_WARNING = "warn";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_FATAL = "fatal";
    public static final int MANAGER_EVENT_ACTION_START_RANGE = 100;
    public static final int MODEL_EVENT_ACTION_START_RANGE = 200;
    public static final int SERVICE_EVENT_ACTION_START_RANGE = 300;
    public static final int SECURITY_EVENT_ACTION_START_RANGE = 400;
    public static final int MANAGEMENT_EVENT_ACTION_START_RANGE = 500;
    public static final int ADMIN_EVENT_ACTION_START_RANGE = 600;
    public static final int CONNECTION_EVENT_ACTION_START_RANGE = 700;
    public static final int MESSAGE_EVENT_ACTION_START_RANGE = 800;
    public static final int SPACE_EVENT_ACTION_START_RANGE = 900;
    public static final int REGISTRY_EVENT_ACTION_START_RANGE = 1000;
    public static final int EXCEPTION_EVENT_ACTION_START_RANGE = 1100;
    public static final int TRANSACTION_EVENT_ACTION_START_RANGE = 1200;
    public static final int CUSTOM_EVENT_ACTION_START_RANGE = 100000;
    public static final int NULL_ACTION = 0;
    public static final Object NULL_MESSAGE = "";
    public final String EVENT_NAME = ClassUtils.getClassName(this.getClass());
    protected String serverId;
    protected long timestamp;
    protected int action = 0;
    private static Map actionIdToName = new ConcurrentHashMap();
    private static Map actionNameToId = new ConcurrentHashMap();
    protected String resourceIdentifier = null;

    public ServerNotification(Object message, int action) {
        this(message, action, null);
    }

    public ServerNotification(Object message, int action, String resourceIdentifier) {
        super(message == null ? NULL_MESSAGE : message);
        this.action = action;
        this.resourceIdentifier = resourceIdentifier;
        if (RegistryContext.getRegistry() != null && null != message) {
            this.serverId = message.toString();
        }
        this.timestamp = System.currentTimeMillis();
    }

    public int getAction() {
        return this.action;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isResourceIdentifierAnUri() {
        return MuleEndpointURI.isMuleUri(this.resourceIdentifier);
    }

    public String toString() {
        return this.EVENT_NAME + "{" + "action=" + ServerNotification.getActionName(this.action) + ", resourceId=" + this.resourceIdentifier + ", serverId=" + this.serverId + ", timestamp=" + this.timestamp + "}";
    }

    protected String getPayloadToString() {
        return this.source.toString();
    }

    public String getType() {
        return TYPE_INFO;
    }

    public String getActionName() {
        return ServerNotification.getActionName(this.action);
    }

    protected static synchronized void registerAction(String name, int i) {
        String lowerCaseName = name.toLowerCase();
        Integer id = new Integer(i);
        if (actionNameToId.containsKey(lowerCaseName)) {
            throw new IllegalStateException("Action " + name + " already registered");
        }
        if (actionIdToName.containsKey(id)) {
            throw new IllegalStateException("Action id " + i + " already registered");
        }
        actionIdToName.put(id, lowerCaseName);
        actionNameToId.put(lowerCaseName, id);
    }

    public static String getActionName(int action) {
        if (action == Integer.MIN_VALUE) {
            return NO_ACTION_NAME;
        }
        Integer key = new Integer(action);
        if (actionIdToName.containsKey(key)) {
            return (String)actionIdToName.get(key);
        }
        throw new IllegalArgumentException("No action with id: " + action);
    }

    public static int getActionId(String action) {
        String lowerCaseName = action.toLowerCase();
        if (actionNameToId.containsKey(lowerCaseName)) {
            return (Integer)actionNameToId.get(lowerCaseName);
        }
        throw new IllegalArgumentException("No action called: " + action);
    }
}

