/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.transaction.TransactionManager;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.Directories;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.agent.Agent;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.FatalException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.store.Store;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.config.MuleConfiguration;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ManagerNotification;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.management.stats.AllStatistics;
import org.mule.util.FileUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.queue.QueueManager;

public class DefaultMuleContext
implements MuleContext {
    private static transient Log logger = LogFactory.getLog(DefaultMuleContext.class);
    private MuleConfiguration config;
    private String id = null;
    private String clusterId = null;
    private String domain = null;
    private long startDate = 0L;
    private AllStatistics stats = new AllStatistics();
    private WorkManager workManager;
    protected LifecycleManager lifecycleManager;
    protected Directories directories;
    protected String systemName;
    protected ServerNotificationManager notificationManager;

    public DefaultMuleContext(LifecycleManager lifecycleManager) {
        if (lifecycleManager == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("lifecycleManager").getMessage());
        }
        this.lifecycleManager = lifecycleManager;
        this.startDate = System.currentTimeMillis();
    }

    public void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getNotificationManager() == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("_muleNotificationManager").getMessage());
        }
        if (this.workManager == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("workManager").getMessage());
        }
        if (this.config == null) {
            logger.info((Object)"A mule configuration object was not registered. Using default configuration");
            this.config = new MuleConfiguration();
        }
        try {
            this.setupIds();
            this.validateEncoding();
            this.validateOSEncoding();
            this.validateXML();
            this.directories = new Directories(FileUtils.newFile(this.config.getWorkingDirectory()));
            this.workManager.start();
            this.getNotificationManager().start(this.workManager);
            this.fireNotification(new ManagerNotification((MuleContext)this, 101));
            this.directories.createDirectories();
            this.lifecycleManager.firePhase(this, "initialise");
            this.fireNotification(new ManagerNotification((MuleContext)this, 102));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void setupIds() throws InitialisationException {
        this.id = this.config.getId();
        this.clusterId = this.config.getClusterId();
        this.domain = this.config.getDomainId();
        if (this.id == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("Instance ID"), (Initialisable)this);
        }
        if (this.clusterId == null) {
            this.clusterId = CoreMessages.notClustered().getMessage();
        }
        if (this.domain == null) {
            try {
                this.domain = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        this.systemName = this.domain + "." + this.clusterId + "." + this.id;
    }

    public synchronized void start() throws MuleException {
        this.lifecycleManager.checkPhase("start");
        if (!this.isStarted()) {
            if (this.getSecurityManager() == null) {
                throw new NullPointerException(CoreMessages.objectIsNull("securityManager").getMessage());
            }
            if (this.getQueueManager() == null) {
                throw new NullPointerException(CoreMessages.objectIsNull("queueManager").getMessage());
            }
            this.fireNotification(new ManagerNotification((MuleContext)this, 103));
            this.directories.deleteMarkedDirectories();
            this.lifecycleManager.firePhase(this, "start");
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.getStartSplash());
            }
            this.fireNotification(new ManagerNotification((MuleContext)this, 104));
        }
    }

    public synchronized void stop() throws MuleException {
        this.lifecycleManager.checkPhase("stop");
        this.fireNotification(new ManagerNotification((MuleContext)this, 105));
        this.lifecycleManager.firePhase(this, "stop");
        this.fireNotification(new ManagerNotification((MuleContext)this, 106));
    }

    public void dispose() {
        if (this.isDisposing()) {
            return;
        }
        ServerNotificationManager notificationManager = this.getNotificationManager();
        this.lifecycleManager.checkPhase("dispose");
        this.fireNotification(new ManagerNotification((MuleContext)this, 107));
        try {
            if (this.isStarted()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            logger.error((Object)("Failed to stop manager: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.lifecycleManager.firePhase(this, "dispose");
        }
        catch (MuleException e) {
            logger.debug((Object)("Failed to cleanly dispose Mule: " + e.getMessage()), (Throwable)e);
        }
        notificationManager.fireNotification(new ManagerNotification((MuleContext)this, 108));
        if (this.startDate > 0L && logger.isInfoEnabled()) {
            logger.info((Object)this.getEndSplash());
        }
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    protected boolean isStopped() {
        return this.lifecycleManager.isPhaseComplete("stop");
    }

    protected boolean isStopping() {
        return "stop".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isStarted() {
        return this.lifecycleManager.isPhaseComplete("start");
    }

    protected boolean isStarting() {
        return "start".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    protected void validateEncoding() throws FatalException {
        String encoding = System.getProperty("org.mule.encoding");
        if (encoding == null) {
            encoding = this.config.getDefaultEncoding();
            System.setProperty("org.mule.encoding", encoding);
        } else {
            this.config.setDefaultEncoding(encoding);
        }
        if (!Charset.isSupported(this.config.getDefaultEncoding())) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("encoding", this.config.getDefaultEncoding()), (Object)this);
        }
    }

    protected void validateOSEncoding() throws FatalException {
        String encoding = System.getProperty("org.mule.osEncoding");
        if (encoding == null) {
            encoding = this.config.getDefaultOSEncoding();
            System.setProperty("org.mule.osEncoding", encoding);
        } else {
            this.config.setDefaultOSEncoding(encoding);
        }
        if (!Charset.isSupported(this.config.getDefaultOSEncoding())) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("osEncoding", this.config.getDefaultOSEncoding()), (Object)this);
        }
    }

    protected void validateXML() throws FatalException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        if (f == null || f.getClass().getName().indexOf("crimson") != -1) {
            throw new FatalException(CoreMessages.valueIsInvalidFor(f.getClass().getName(), "javax.xml.parsers.SAXParserFactory"), (Object)this);
        }
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public Store getStore(String name) throws MuleException {
        return null;
    }

    public Store createStore(String name) throws MuleException {
        return null;
    }

    public void removeStore(Store store) {
        store.dispose();
    }

    public long getStartDate() {
        return this.startDate;
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void setStatistics(AllStatistics stat) {
        this.stats = stat;
    }

    public Directories getDirectories() {
        return this.directories;
    }

    public void registerListener(ServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    public void registerListener(ServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    public void unregisterListener(ServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    public void fireNotification(ServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleEvent Manager is not enabled, ignoring notification: " + notification));
        }
    }

    public void setId(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Management Context ID can't be null or empty");
        }
        this.checkLifecycleForPropertySet("id", "start");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.checkLifecycleForPropertySet("domain", "initialise");
        this.domain = domain;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.checkLifecycleForPropertySet("clusterId", "initialise");
        this.clusterId = clusterId;
    }

    public void setSecurityManager(SecurityManager securityManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        this.getRegistry().registerObject("_muleSecurityManager", securityManager);
    }

    public SecurityManager getSecurityManager() {
        Collection temp;
        SecurityManager securityManager = (SecurityManager)this.getRegistry().lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.getRegistry().lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = (SecurityManager)temp.iterator().next();
        }
        return securityManager;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.checkLifecycleForPropertySet("workManager", "initialise");
        this.workManager = workManager;
    }

    public QueueManager getQueueManager() {
        Collection temp;
        QueueManager queueManager = (QueueManager)this.getRegistry().lookupObject("_muleQueueManager");
        if (queueManager == null && (temp = this.getRegistry().lookupObjects(QueueManager.class)).size() > 0) {
            queueManager = (QueueManager)temp.iterator().next();
        }
        return queueManager;
    }

    public void setQueueManager(QueueManager queueManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleQueueManager", "initialise");
        this.getRegistry().registerObject("_muleQueueManager", queueManager);
    }

    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.getRegistry().registerObject("_muleTransactionManager", manager);
    }

    public TransactionManager getTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.getRegistry().lookupObject("_muleTransactionManager");
        if (transactionManager == null) {
            Collection temp = this.getRegistry().lookupObjects(TransactionManagerFactory.class);
            if (temp.size() > 0) {
                try {
                    transactionManager = ((TransactionManagerFactory)temp.iterator().next()).create();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage("Unable to create transaction manager"));
                }
            } else {
                temp = this.getRegistry().lookupObjects(TransactionManager.class);
                if (temp.size() > 0) {
                    transactionManager = (TransactionManager)temp.iterator().next();
                }
            }
        }
        return transactionManager;
    }

    private String getStartSplash() {
        String notset = CoreMessages.notSet().getMessage();
        ArrayList<String> message = new ArrayList<String>();
        Manifest mf = MuleManifest.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            message.add(StringUtils.defaultString((String)MuleManifest.getProductDescription(), (String)notset));
            message.add(CoreMessages.version().getMessage() + " Build: " + StringUtils.defaultString((String)MuleManifest.getBuildNumber(), (String)notset));
            message.add(StringUtils.defaultString((String)MuleManifest.getVendorName(), (String)notset));
            message.add(StringUtils.defaultString((String)MuleManifest.getProductMoreInfo(), (String)notset));
        } else {
            message.add(CoreMessages.versionNotSet().getMessage());
        }
        message.add(" ");
        message.add(CoreMessages.serverStartedAt(this.getStartDate()).getMessage());
        message.add("Server ID: " + this.id);
        message.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        String patch = System.getProperty("sun.os.patch.level", null);
        message.add("OS: " + System.getProperty("os.name") + (patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        try {
            InetAddress host = InetAddress.getLocalHost();
            message.add("Host: " + host.getHostName() + " (" + host.getHostAddress() + ")");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        message.add(" ");
        Collection agents = RegistryContext.getRegistry().getAgents();
        if (agents.size() == 0) {
            message.add(CoreMessages.agentsRunning().getMessage() + " " + CoreMessages.none().getMessage());
        } else {
            message.add(CoreMessages.agentsRunning().getMessage());
            for (Agent umoAgent : agents) {
                message.add("  " + umoAgent.getDescription());
            }
        }
        return StringMessageUtils.getBoilerPlate(message, '*', 70);
    }

    private String getEndSplash() {
        ArrayList<String> message = new ArrayList<String>(2);
        long currentTime = System.currentTimeMillis();
        message.add(CoreMessages.shutdownNormally(new Date()).getMessage());
        long duration = 10L;
        if (this.startDate > 0L) {
            duration = currentTime - this.startDate;
        }
        message.add(CoreMessages.serverWasUpForDuration(duration).getMessage());
        return StringMessageUtils.getBoilerPlate(message, '*', 78);
    }

    public void register() throws RegistrationException {
        throw new UnsupportedOperationException("register");
    }

    public void deregister() throws RegistrationException {
        throw new UnsupportedOperationException("deregister");
    }

    public String getRegistryId() {
        throw new UnsupportedOperationException("registryId");
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has been gone through the " + phase + " phase.");
        }
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public Registry getRegistry() {
        return RegistryContext.getRegistry();
    }

    public void applyLifecycle(Object object) throws MuleException {
        this.lifecycleManager.applyLifecycle(this, object);
    }

    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(MuleConfiguration config) {
        this.config = config;
    }
}

