/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.properties;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Date;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.UUID;
import org.mule.util.properties.PropertyExtractor;

public class FunctionPropertyExtractor
implements PropertyExtractor {
    public static final String NAME = "function";
    public static final String NOW_FUNCTION = "now";
    public static final String DATE_FUNCTION = "date";
    public static final String UUID_FUNCTION = "uuid";
    public static final String HOSTNAME_FUNCTION = "hostname";
    public static final String IP_FUNCTION = "ip";

    public Object getProperty(String name, Object message) {
        if (name.equalsIgnoreCase(NOW_FUNCTION)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (name.equalsIgnoreCase(DATE_FUNCTION)) {
            return new Date(System.currentTimeMillis());
        }
        if (name.equalsIgnoreCase(UUID_FUNCTION)) {
            return UUID.getUUID();
        }
        if (name.equalsIgnoreCase(HOSTNAME_FUNCTION)) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(name), (Throwable)e);
            }
        }
        if (name.equalsIgnoreCase(IP_FUNCTION)) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(name), (Throwable)e);
            }
        }
        throw new IllegalArgumentException(name);
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

