/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.object;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.impl.UMOComponentAware;
import org.mule.umo.UMOComponent;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.object.ObjectFactory;

public abstract class AbstractObjectFactory
implements ObjectFactory,
UMOComponentAware {
    public static final String ATTRIBUTE_OBJECT_CLASS_NAME = "objectClassName";
    public static final String ATTRIBUTE_OBJECT_CLASS = "objectClass";
    protected String objectClassName;
    protected Class objectClass = null;
    protected Map properties = null;
    UMOComponent component;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public AbstractObjectFactory() {
    }

    public AbstractObjectFactory(String objectClassName) {
        this(objectClassName, null);
    }

    public AbstractObjectFactory(String objectClassName, Map properties) {
        this.objectClassName = objectClassName;
        this.properties = properties;
    }

    public AbstractObjectFactory(Class objectClass) {
        this(objectClass, null);
    }

    public AbstractObjectFactory(Class objectClass, Map properties) {
        this.objectClass = objectClass;
        this.properties = properties;
    }

    public Object getOrCreate() throws Exception {
        if (this.objectClass == null) {
            this.objectClass = ClassUtils.getClass((String)this.objectClassName);
        }
        Object object = ClassUtils.instanciateClass(this.objectClass, ClassUtils.NO_ARGS);
        if (this.properties != null) {
            BeanUtils.populate((Object)object, (Map)this.properties);
        }
        if (this.component != null) {
            BeanUtils.setProperty((Object)object, (String)"component", (Object)this.component);
        }
        if (object instanceof Initialisable) {
            ((Initialisable)object).initialise();
        }
        return object;
    }

    public void setComponent(UMOComponent component) throws ConfigurationException {
        this.component = component;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }
}

