/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mule.util.counters.Counter;
import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AggregateCounter;

public abstract class AbstractCounter
implements Counter {
    private final CounterFactory.Type type;
    private final String name;
    private final List aggregates;

    public AbstractCounter(String name, CounterFactory.Type type) {
        this.name = name;
        this.type = type;
        this.aggregates = Collections.synchronizedList(new ArrayList());
    }

    public CounterFactory.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public abstract double increment();

    public abstract double incrementBy(double var1);

    public abstract double decrement();

    public abstract void setRawValue(double var1);

    public abstract double nextValue();

    protected void addAggregate(AggregateCounter counter) {
        this.aggregates.add(counter);
    }

    protected void propagate() {
        Iterator it = this.aggregates.iterator();
        while (it.hasNext()) {
            AggregateCounter agg = (AggregateCounter)it.next();
            agg.compute();
        }
    }
}

