/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.security;

import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.impl.RequestContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.security.UMOSecurityContext;

public class UnauthorisedException
extends SecurityException {
    private static final long serialVersionUID = -6664384216189042672L;

    public UnauthorisedException(Message message) {
        super(message, RequestContext.getEventContext().getMessage());
    }

    public UnauthorisedException(Message message, Throwable cause) {
        super(message, RequestContext.getEventContext().getMessage(), cause);
    }

    public UnauthorisedException(Message message, UMOMessage umoMessage) {
        super(message, umoMessage);
    }

    public UnauthorisedException(Message message, UMOMessage umoMessage, Throwable cause) {
        super(message, umoMessage, cause);
    }

    public UnauthorisedException(UMOMessage umoMessage, UMOSecurityContext context, UMOImmutableEndpoint endpoint, UMOEndpointSecurityFilter filter) {
        super(UnauthorisedException.constructMessage(context, endpoint, filter), umoMessage);
    }

    private static Message constructMessage(UMOSecurityContext context, UMOImmutableEndpoint endpoint, UMOEndpointSecurityFilter filter) {
        Message m = null;
        m = context == null ? CoreMessages.authSetButNoContext(filter.getClass().getName()) : CoreMessages.authFailedForUser(context.getAuthentication().getPrincipal());
        m.setNextMessage(CoreMessages.authDeniedOnEndpoint(endpoint.getEndpointURI()));
        return m;
    }
}

