/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public abstract class UMOException
extends Exception {
    private Map info = new HashMap();
    private int errorCode = -1;
    private String message = null;
    private Message i18nMessage;

    public UMOException(Message message) {
        this.setMessage(message);
    }

    public UMOException(Message message, Throwable cause) {
        super(cause instanceof InvocationTargetException ? ((InvocationTargetException)cause).getTargetException() : cause);
        this.setMessage(message);
    }

    public UMOException(Throwable cause) {
        super(cause instanceof InvocationTargetException ? ((InvocationTargetException)cause).getTargetException() : cause);
        this.setMessage(MessageFactory.createStaticMessage(cause.getMessage() + " (" + cause.getClass().getName() + ")"));
        this.initialise();
    }

    protected UMOException() {
        this.initialise();
    }

    protected void setMessage(Message message) {
        this.initialise();
        this.message = message.getMessage();
        this.i18nMessage = message;
    }

    protected void setMessage(String message) {
        this.initialise();
        this.message = message;
        if (this.i18nMessage == null) {
            this.i18nMessage = MessageFactory.createStaticMessage(message);
        }
    }

    public int getExceptionCode() {
        return this.errorCode;
    }

    public Message getI18nMessage() {
        return this.i18nMessage;
    }

    public int getMessageCode() {
        return this.i18nMessage == null ? 0 : this.i18nMessage.getCode();
    }

    public void addInfo(String name, Object info) {
        this.info.put(name, info);
    }

    protected void appendMessage(String s) {
        this.message = this.message + s;
    }

    protected void prependMessage(String s) {
        this.message = this.message + ". " + s;
    }

    protected void setExceptionCode(int code) {
        this.errorCode = code;
    }

    public final String getMessage() {
        return this.message;
    }

    protected void initialise() {
        this.setExceptionCode(ExceptionHelper.getErrorCode(this.getClass()));
        String javadoc = ExceptionHelper.getJavaDocUrl(this.getClass());
        String doc = ExceptionHelper.getDocUrl(this.getClass());
        if (javadoc != null) {
            this.info.put("JavaDoc", javadoc);
        }
        if (doc != null) {
            this.info.put("Other Doc", doc);
        }
    }

    public String getDetailedMessage() {
        UMOException e = ExceptionHelper.getRootMuleException(this);
        if (!e.equals(this)) {
            return this.getMessage();
        }
        StringBuffer buf = new StringBuffer(1024);
        buf.append(SystemUtils.LINE_SEPARATOR).append(StringUtils.repeat('*', 80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Message               : ").append(this.message).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Type                  : ").append(this.getClass().getName()).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Code                  : ").append("MULE_ERROR-").append(this.getExceptionCode() + this.getMessageCode()).append(SystemUtils.LINE_SEPARATOR);
        Map info = ExceptionHelper.getExceptionInfo(this);
        Iterator iterator = info.keySet().iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            int pad = 22 - s.length();
            buf.append(s);
            if (pad > 0) {
                buf.append(StringUtils.repeat(' ', pad));
            }
            buf.append(": ");
            buf.append(info.get(s)).append(SystemUtils.LINE_SEPARATOR);
        }
        buf.append(StringUtils.repeat('*', 80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append(CoreMessages.exceptionStackIs()).append(SystemUtils.LINE_SEPARATOR);
        buf.append(ExceptionHelper.getExceptionStack(this));
        buf.append(StringUtils.repeat('*', 80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append(CoreMessages.rootStackTrace()).append(SystemUtils.LINE_SEPARATOR);
        Throwable root = ExceptionHelper.getRootException(this);
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        root.printStackTrace(p);
        buf.append(w.toString()).append(SystemUtils.LINE_SEPARATOR);
        buf.append(StringUtils.repeat('*', 80)).append(SystemUtils.LINE_SEPARATOR);
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UMOException)) {
            return false;
        }
        UMOException umoException = (UMOException)o;
        if (this.errorCode != umoException.errorCode) {
            return false;
        }
        if (this.i18nMessage != null ? !this.i18nMessage.equals(umoException.i18nMessage) : umoException.i18nMessage != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(umoException.message) : umoException.message != null);
    }

    public int hashCode() {
        int result = this.errorCode;
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 29 * result + (this.i18nMessage != null ? this.i18nMessage.hashCode() : 0);
        return result;
    }

    public Map getInfo() {
        return this.info;
    }
}

