/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo;

import java.util.Map;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;

public class MessagingException
extends UMOException {
    private static final long serialVersionUID = 6941498759267936649L;
    protected final transient UMOMessage umoMessage;

    public MessagingException(Message message, UMOMessage umoMessage) {
        this.umoMessage = umoMessage;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, UMOMessage umoMessage, Throwable cause) {
        super(cause);
        this.umoMessage = umoMessage;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, Object payload) {
        this.umoMessage = payload == null ? RequestContext.getEventContext().getMessage() : new MuleMessage(payload, (Map)null);
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, Object payload, Throwable cause) {
        super(cause);
        this.umoMessage = payload == null ? RequestContext.getEventContext().getMessage() : new MuleMessage(payload, (Map)null);
        this.setMessage(this.generateMessage(message));
    }

    private String generateMessage(Message message) {
        StringBuffer buf = new StringBuffer(80);
        if (message != null) {
            buf.append(message.getMessage()).append(". ");
        }
        if (this.umoMessage != null) {
            Object payload = this.umoMessage.getPayload();
            if (payload == null) {
                payload = NullPayload.getInstance();
            }
            buf.append(CoreMessages.messageIsOfType(payload.getClass()).getMessage());
            this.addInfo("Payload", payload.toString());
        } else {
            buf.append("The current UMOMessage is null! Please report this to ").append(MuleManifest.getDevListEmail());
            this.addInfo("Payload", NullPayload.getInstance().toString());
        }
        return buf.toString();
    }

    public UMOMessage getUmoMessage() {
        return this.umoMessage;
    }
}

