/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.TestCaseWatchdog;
import org.mule.tck.TestCaseWatchdogTimeoutHandler;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.FileUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;
import org.mule.util.concurrent.Latch;

public abstract class AbstractMuleTestCase
extends TestCase
implements TestCaseWatchdogTimeoutHandler {
    public static final String[] IGNORED_DOT_MULE_DIRS = new String[]{"transaction-log"};
    protected static UMOManagementContext managementContext;
    private static final boolean verbose;
    private static final Map testInfos;
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private boolean startContext = false;
    private boolean offline = "true".equalsIgnoreCase(System.getProperty("org.mule.offline"));
    private TestCaseWatchdog watchdog;
    public static final String TEST_MESSAGE = "Test Message";
    public static final long LOCK_TIMEOUT = 30000L;
    protected Latch callbackCalled;

    public AbstractMuleTestCase() {
        TestInfo info = (TestInfo)testInfos.get(this.getClass().getName());
        if (info == null) {
            info = this.createTestInfo();
            testInfos.put(this.getClass().getName(), info);
        }
        this.registerTestMethod();
    }

    protected void registerTestMethod() {
        if (this.getName() != null) {
            this.getTestInfo().incTestCount(this.getName());
        }
    }

    public void setName(String name) {
        super.setName(name);
        this.registerTestMethod();
    }

    protected TestInfo createTestInfo() {
        return new TestInfo(this);
    }

    protected TestInfo getTestInfo() {
        return (TestInfo)testInfos.get(this.getClass().getName());
    }

    private void clearInfo() {
        testInfos.remove(this.getClass().getName());
    }

    public String getName() {
        if (verbose && super.getName() != null) {
            return super.getName().substring(4).replaceAll("([A-Z])", " $1").toLowerCase() + " ";
        }
        return super.getName();
    }

    public void run(TestResult result) {
        if (this.isExcluded()) {
            if (verbose) {
                this.logger.info((Object)(this.getClass().getName() + " excluded"));
            }
            return;
        }
        if (this.isDisabledInThisEnvironment()) {
            if (verbose) {
                this.logger.info((Object)(this.getClass().getName() + " disabled"));
            }
            return;
        }
        super.run(result);
    }

    public void runBare() throws Throwable {
        if (this.isDisabledInThisEnvironment(super.getName())) {
            this.logger.warn((Object)(this.getClass().getName() + "." + super.getName() + " disabled in this environment"));
            return;
        }
        super.runBare();
    }

    protected boolean isDisabledInThisEnvironment() {
        return false;
    }

    protected boolean isExcluded() {
        return this.getTestInfo().isExcluded();
    }

    protected boolean isDisabledInThisEnvironment(String testMethodName) {
        return false;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            this.logger.warn((Object)StringMessageUtils.getBoilerPlate("Working offline cannot run test: " + method, '=', 80));
        }
        return this.offline;
    }

    protected boolean isDisposeManagerPerSuite() {
        return this.getTestInfo().isDisposeManagerPerSuite();
    }

    protected void setDisposeManagerPerSuite(boolean val) {
        this.getTestInfo().setDisposeManagerPerSuite(val);
    }

    protected TestCaseWatchdog createWatchdog() {
        return new TestCaseWatchdog(10L, TimeUnit.MINUTES, this);
    }

    public void handleTimeout(long timeout, TimeUnit unit) {
        this.logger.fatal((Object)("Timeout of " + unit.toMillis(timeout) + "ms exceeded - exiting VM!"));
        Runtime.getRuntime().halt(1);
    }

    protected final void setUp() throws Exception {
        this.watchdog = this.createWatchdog();
        this.watchdog.start();
        if (verbose) {
            System.out.println(StringMessageUtils.getBoilerPlate("Testing: " + this.toString(), '=', 80));
        }
        try {
            if (this.getTestInfo().getRunCount() == 0) {
                if (this.getTestInfo().isDisposeManagerPerSuite()) {
                    this.disposeManager();
                }
                this.suitePreSetUp();
            }
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            managementContext = this.createManagementContext();
            MuleServer.setManagementContext(managementContext);
            if (this.isStartContext() && !managementContext.isStarted()) {
                managementContext.start();
            }
            this.doSetUp();
        }
        catch (Exception e) {
            this.getTestInfo().incRunCount();
            throw e;
        }
    }

    protected UMOManagementContext createManagementContext() throws Exception {
        UMOManagementContext context;
        if (this.getTestInfo().isDisposeManagerPerSuite() && managementContext != null) {
            context = managementContext;
        } else {
            ConfigurationBuilder builder = this.getBuilder();
            context = builder.configure(this.getConfigurationResources(), this.getStartUpProperties());
        }
        return context;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        MuleXmlConfigurationBuilder builder = new MuleXmlConfigurationBuilder();
        builder.setStartContext(false);
        return builder;
    }

    protected String getConfigurationResources() {
        return "";
    }

    protected Properties getStartUpProperties() {
        return null;
    }

    protected void suitePreSetUp() throws Exception {
    }

    protected void suitePostTearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void tearDown() throws Exception {
        try {
            this.doTearDown();
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.getTestInfo().incRunCount();
                if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) throw throwable;
                try {
                    this.suitePostTearDown();
                    throw throwable;
                }
                finally {
                    this.clearInfo();
                    this.disposeManager();
                }
            }
            finally {
                this.watchdog.cancel();
            }
        }
        try {
            this.getTestInfo().incRunCount();
            if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) return;
            try {
                this.suitePostTearDown();
                return;
            }
            finally {
                this.clearInfo();
                this.disposeManager();
            }
        }
        finally {
            this.watchdog.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeManager() {
        try {
            if (managementContext != null && !managementContext.isDisposed() && !managementContext.isDisposing()) {
                managementContext.dispose();
                if (RegistryContext.getRegistry() != null) {
                    String workingDir = RegistryContext.getConfiguration().getWorkingDirectory();
                    FileUtils.deleteTree(FileUtils.newFile(workingDir), IGNORED_DOT_MULE_DIRS);
                    RegistryContext.getRegistry().dispose();
                }
            }
            FileUtils.deleteTree(FileUtils.newFile("./ActiveMQ"));
        }
        finally {
            managementContext = null;
            RegistryContext.setRegistry(null);
        }
    }

    protected void doSetUp() throws Exception {
    }

    protected void doTearDown() throws Exception {
    }

    public static UMOEndpoint getTestEndpoint(String name, String type) throws Exception {
        return MuleTestUtils.getTestEndpoint(name, type, managementContext);
    }

    public static UMOEvent getTestEvent(Object data, UMOComponent component) throws Exception {
        return MuleTestUtils.getTestEvent(data, component, managementContext);
    }

    public static UMOEvent getTestEvent(Object data) throws Exception {
        return MuleTestUtils.getTestEvent(data, managementContext);
    }

    public static UMOEventContext getTestEventContext(Object data) throws Exception {
        return MuleTestUtils.getTestEventContext(data, managementContext);
    }

    public static UMOTransformer getTestTransformer() throws Exception {
        return MuleTestUtils.getTestTransformer();
    }

    public static UMOEvent getTestEvent(Object data, UMOImmutableEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, endpoint, managementContext);
    }

    public static UMOEvent getTestEvent(Object data, UMOComponent component, UMOImmutableEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, component, endpoint, managementContext);
    }

    public static UMOSession getTestSession(UMOComponent component) {
        return MuleTestUtils.getTestSession(component);
    }

    public static TestConnector getTestConnector() throws Exception {
        return MuleTestUtils.getTestConnector(managementContext);
    }

    public static UMOComponent getTestComponent() throws Exception {
        return MuleTestUtils.getTestComponent(managementContext);
    }

    public static UMOComponent getTestComponent(String name, Class clazz) throws Exception {
        return MuleTestUtils.getTestComponent(name, clazz, managementContext);
    }

    public static UMOComponent getTestComponent(String name, Class clazz, Map props) throws Exception {
        return MuleTestUtils.getTestComponent(name, clazz, props, managementContext);
    }

    protected boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    static {
        testInfos = Collections.synchronizedMap(new HashMap());
        String muleOpts = SystemUtils.getenv("MULE_TEST_OPTS");
        if (StringUtils.isNotBlank((String)muleOpts)) {
            Map parsedOpts = SystemUtils.parsePropertyDefinitions(muleOpts);
            String optVerbose = (String)parsedOpts.get("mule.verbose");
            verbose = Boolean.valueOf(optVerbose);
        } else {
            verbose = true;
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
    }

    public static class TestInfo {
        private final String name;
        private boolean disposeManagerPerSuite = false;
        private boolean excluded = false;
        private volatile int testCount = 0;
        private volatile int runCount = 0;
        private Set registeredTestMethod = new HashSet();

        public static URL getClassPathRoot(Class clazz) {
            CodeSource cs = clazz.getProtectionDomain().getCodeSource();
            return cs != null ? cs.getLocation() : null;
        }

        public TestInfo(TestCase test) {
            this.name = test.getClass().getName();
            try {
                URL[] urls = new URL[]{TestInfo.getClassPathRoot(test.getClass())};
                URL fileUrl = new URLClassLoader(urls).getResource("mule-test-exclusions.txt");
                if (fileUrl != null) {
                    LineIterator lines = FileUtils.lineIterator((File)FileUtils.newFile(fileUrl.getFile()));
                    this.excluded = IteratorUtils.filteredIterator((Iterator)lines, (Predicate)new Predicate(this){
                        private final /* synthetic */ TestInfo this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public boolean evaluate(Object object) {
                            return StringUtils.equals((String)TestInfo.access$000(this.this$0), (String)StringUtils.trimToEmpty((String)((String)object)));
                        }
                    }).hasNext();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int getTestCount() {
            return this.testCount;
        }

        public synchronized void incTestCount(String name) {
            if (!this.registeredTestMethod.contains(name)) {
                ++this.testCount;
                this.registeredTestMethod.add(name);
            }
        }

        public int getRunCount() {
            return this.runCount;
        }

        public void incRunCount() {
            ++this.runCount;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDisposeManagerPerSuite() {
            return this.disposeManagerPerSuite;
        }

        public void setDisposeManagerPerSuite(boolean disposeManagerPerSuite) {
            this.disposeManagerPerSuite = disposeManagerPerSuite;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public synchronized String toString() {
            StringBuffer buf = new StringBuffer();
            return buf.append(this.name).append(", (").append(this.runCount).append(" / ").append(this.testCount).append(") tests run, disposePerSuite=").append(this.disposeManagerPerSuite).toString();
        }

        static /* synthetic */ String access$000(TestInfo x0) {
            return x0.name;
        }
    }
}

