/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.Iterator;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.DynamicEndpointURIEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;
import org.mule.util.TemplateParser;

public class TemplateEndpointRouter
extends FilteringOutboundRouter {
    private TemplateParser parser = TemplateParser.createSquareBracesStyleParser();

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        try {
            MuleEndpointURI newUri;
            UMOImmutableEndpoint ep = (UMOImmutableEndpoint)this.endpoints.get(0);
            String uri = ep.getEndpointURI().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Uri before parsing is: " + uri));
            }
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.putAll(ep.getProperties());
            Iterator iterator = message.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                String propertyKey = (String)iterator.next();
                props.put(propertyKey, message.getProperty(propertyKey));
            }
            uri = this.parser.parse(props, uri);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Uri after parsing is: " + uri));
            }
            if (!(newUri = new MuleEndpointURI(uri)).getScheme().equalsIgnoreCase(ep.getEndpointURI().getScheme())) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.schemeCannotChangeForRouter(ep.getEndpointURI().getScheme(), newUri.getScheme()), message, ep);
            }
            ep = new DynamicEndpointURIEndpoint(ep, new MuleEndpointURI(uri));
            if (synchronous) {
                result = this.send(session, message, ep);
            } else {
                this.dispatch(session, message, ep);
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, (UMOImmutableEndpoint)this.endpoints.get(0), (Throwable)e);
        }
        return result;
    }
}

