/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.List;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;

public class MulticastingRouter
extends FilteringOutboundRouter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(this.endpoints.size());
            }
        }
        try {
            List list = this.endpoints;
            synchronized (list) {
                for (int i = 0; i < this.endpoints.size(); ++i) {
                    UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)this.endpoints.get(i);
                    if (synchronous) {
                        if (result == null) {
                            result = this.send(session, message, endpoint);
                            continue;
                        }
                        String def = (String)endpoint.getProperties().get("default");
                        if (def != null) {
                            result = this.send(session, message, endpoint);
                            continue;
                        }
                        this.send(session, message, endpoint);
                        continue;
                    }
                    this.dispatch(session, message, endpoint);
                }
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, (UMOImmutableEndpoint)this.endpoints.get(0), (Throwable)e);
        }
        return result;
    }
}

