/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContextAware;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;
import org.mule.util.StringUtils;
import org.mule.util.properties.PropertyExtractorManager;

public class EndpointSelector
extends FilteringOutboundRouter
implements ManagementContextAware {
    public static final String DEFAULT_SELECTOR_PROPERTY = "endpoint";
    private String selectorProperty = "endpoint";

    /*
     * WARNING - void declaration
     */
    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        void var4_5;
        List<Object> endpoints;
        Object property = PropertyExtractorManager.processExpression(this.getSelectorProperty(), message);
        if (property == null) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSetOnEvent(this.getSelectorProperty()), message, null);
        }
        if (property instanceof String) {
            endpoints = new ArrayList<Object>(1);
            endpoints.add(property);
        } else if (property instanceof List) {
            endpoints = (List)property;
        } else {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSupportedType(this.getSelectorProperty(), new Class[]{String.class, List.class}, property.getClass()), message, null);
        }
        UMOMessage result = null;
        Iterator iterator = var4_5.iterator();
        while (iterator.hasNext()) {
            String endpointName = iterator.next().toString();
            if (StringUtils.isEmpty((String)endpointName)) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.objectIsNull("Endpoint Name: " + this.getSelectorProperty()), message, null);
            }
            UMOImmutableEndpoint ep = null;
            try {
                ep = this.lookupEndpoint(endpointName);
                if (ep == null) {
                    throw new CouldNotRouteOutboundMessageException(CoreMessages.objectNotFound("Endpoint", endpointName), message, ep);
                }
                if (synchronous) {
                    result = this.send(session, message, ep);
                    continue;
                }
                this.dispatch(session, message, ep);
            }
            catch (UMOException e) {
                throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
            }
        }
        return result;
    }

    protected UMOImmutableEndpoint lookupEndpoint(String endpointName) throws UMOException {
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOImmutableEndpoint ep = (UMOImmutableEndpoint)iterator.next();
            if (endpointName.equals(ep.getEndpointURI().getEndpointName())) {
                return ep;
            }
            if (endpointName.equals(ep.getName())) {
                return ep;
            }
            if (!endpointName.equals(ep.getEndpointURI().getUri().toString())) continue;
            return ep;
        }
        return this.getManagementContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName);
    }

    public String getSelectorProperty() {
        return this.selectorProperty;
    }

    public void setSelectorProperty(String selectorProperty) {
        this.selectorProperty = selectorProperty;
    }
}

