/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.mule.config.i18n.CoreMessages;
import org.mule.routing.inbound.IdempotentInMemoryMessageIdStore;
import org.mule.routing.inbound.IdempotentMessageIdStore;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.routing.RoutingException;

public class IdempotentReceiver
extends SelectiveConsumer {
    protected volatile IdempotentMessageIdStore idStore;
    protected volatile String assignedComponentName;
    protected volatile int maxMessages = -1;
    protected volatile int messageTTL = 300;
    protected volatile int expirationInterval = 60;

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getMessageTTL() {
        return this.messageTTL;
    }

    public void setMessageTTL(int messageTTL) {
        this.messageTTL = messageTTL;
    }

    public int getExpirationInterval() {
        return this.expirationInterval;
    }

    public void setExpirationInterval(int expirationInterval) {
        if (expirationInterval <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Integer(expirationInterval)).toString());
        }
        this.expirationInterval = expirationInterval;
    }

    protected void initialize(UMOEvent event) throws RoutingException {
        if (this.assignedComponentName == null && this.idStore == null) {
            this.assignedComponentName = event.getComponent().getName();
            this.idStore = this.createMessageIdStore();
        }
    }

    protected IdempotentMessageIdStore createMessageIdStore() {
        return new IdempotentInMemoryMessageIdStore(this.assignedComponentName, this.maxMessages, this.messageTTL, this.expirationInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMatch(UMOEvent event) throws MessagingException {
        if (this.idStore == null) {
            IdempotentReceiver idempotentReceiver = this;
            synchronized (idempotentReceiver) {
                this.initialize(event);
            }
        }
        try {
            return !this.idStore.containsId(this.getIdForEvent(event));
        }
        catch (Exception ex) {
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)ex);
        }
    }

    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        String eventComponentName = event.getComponent().getName();
        if (!this.assignedComponentName.equals(eventComponentName)) {
            IllegalArgumentException iex = new IllegalArgumentException("This receiver is assigned to component: " + this.assignedComponentName + " but has received an event for component: " + eventComponentName + ". Please check your config to make sure each component" + "has its own instance of IdempotentReceiver.");
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)iex);
        }
        Object id = this.getIdForEvent(event);
        try {
            if (this.idStore.storeId(id)) {
                return new UMOEvent[]{event};
            }
            return null;
        }
        catch (Exception e) {
            throw new RoutingException(CoreMessages.failedToWriteMessageToStore(id, this.assignedComponentName), event.getMessage(), event.getEndpoint(), e);
        }
    }

    protected Object getIdForEvent(UMOEvent event) throws MessagingException {
        return event.getMessage().getUniqueId();
    }
}

