/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOOutboundRouterCollection;

public class ForwardingConsumer
extends SelectiveConsumer {
    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        if (super.process(event) != null) {
            UMOOutboundRouterCollection router = event.getComponent().getOutboundRouter();
            event.setStopFurtherProcessing(true);
            if (router == null) {
                this.logger.debug((Object)"Descriptor has no outbound router configured to forward to, continuing with normal processing");
                return new UMOEvent[]{event};
            }
            try {
                MuleMessage message = new MuleMessage(event.getTransformedMessage(), event.getMessage());
                UMOMessage response = router.route(message, event.getSession(), event.isSynchronous());
                if (response != null) {
                    return new UMOEvent[]{new MuleEvent(response, event)};
                }
                return null;
            }
            catch (UMOException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        return null;
    }
}

