/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.Arrays;
import java.util.Comparator;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;

public abstract class AbstractEventResequencer
extends SelectiveConsumer {
    protected static final String NO_CORRELATION_ID = "no-id";
    private final ConcurrentMap eventGroups = new ConcurrentHashMap();
    private volatile Comparator comparator;

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator eventComparator) {
        this.comparator = eventComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        UMOEvent[] result = null;
        if (!this.isMatch(event)) return result;
        boolean miss = false;
        Object groupId = this.getEventGroupIdForEvent(event);
        while (true) {
            EventGroup group;
            if (miss) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if ((group = this.getEventGroup(groupId)) == null) {
                group = this.addEventGroup(this.createEventGroup(event, groupId));
            }
            EventGroup eventGroup = group;
            synchronized (eventGroup) {
                if (group == this.getEventGroup(groupId)) {
                    group.addEvent(event);
                    if (!this.shouldResequenceEvents(group)) return result;
                    result = this.resequenceEvents(group);
                    this.removeEventGroup(group);
                    return result;
                }
                miss = true;
            }
        }
    }

    protected EventGroup createEventGroup(UMOEvent event, Object groupId) {
        return new EventGroup(groupId);
    }

    protected Object getEventGroupIdForEvent(UMOEvent event) {
        String groupId = event.getMessage().getCorrelationId();
        if (groupId == null) {
            groupId = NO_CORRELATION_ID;
        }
        return groupId;
    }

    protected EventGroup getEventGroup(Object groupId) {
        return (EventGroup)this.eventGroups.get(groupId);
    }

    protected EventGroup addEventGroup(EventGroup group) {
        EventGroup previous = (EventGroup)this.eventGroups.putIfAbsent(group.getGroupId(), (Object)group);
        return previous != null ? previous : group;
    }

    protected void removeEventGroup(EventGroup group) {
        this.eventGroups.remove(group.getGroupId());
    }

    protected UMOEvent[] resequenceEvents(EventGroup events) {
        if (events == null || events.size() == 0) {
            return EventGroup.EMPTY_EVENTS_ARRAY;
        }
        UMOEvent[] result = events.toArray();
        Comparator cmp = this.getComparator();
        if (cmp != null) {
            Arrays.sort(result, cmp);
        } else {
            this.logger.debug((Object)"Event comparator is null, events were not reordered");
        }
        return result;
    }

    protected abstract boolean shouldResequenceEvents(EventGroup var1);
}

