/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.util.List;
import java.util.Properties;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.endpoint.EndpointURIBuilder;
import org.mule.impl.endpoint.UrlEndpointURIBuilder;
import org.mule.providers.NullPayload;
import org.mule.providers.service.TransportFactory;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.providers.service.TransportServiceException;
import org.mule.registry.AbstractServiceDescriptor;
import org.mule.registry.Registry;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOMessageRequesterFactory;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.object.ObjectFactory;

public class DefaultTransportServiceDescriptor
extends AbstractServiceDescriptor
implements TransportServiceDescriptor {
    private String connector;
    private String connectorFactory;
    private String dispatcherFactory;
    private String requesterFactory;
    private String transactionFactory;
    private String messageAdapter;
    private String messageReceiver;
    private String transactedMessageReceiver;
    private String xaTransactedMessageReceiver;
    private String endpointBuilder;
    private String sessionHandler;
    private String defaultInboundTransformer;
    private String defaultOutboundTransformer;
    private String defaultResponseTransformer;
    private UMOTransformer inboundTransformer;
    private UMOTransformer outboundTransformer;
    private UMOTransformer responseTransformer;
    private Properties exceptionMappings = new Properties();

    public DefaultTransportServiceDescriptor(String service, Properties props, Registry registry) {
        super(service);
        this.connector = this.removeProperty("connector", props);
        this.connectorFactory = this.removeProperty("connector.factory", props);
        this.dispatcherFactory = this.removeProperty("dispatcher.factory", props);
        this.requesterFactory = this.removeProperty("requester.factory", props);
        this.transactionFactory = this.removeProperty("dispatcher.factory", props);
        this.messageReceiver = this.removeProperty("message.receiver", props);
        this.transactedMessageReceiver = this.removeProperty("transacted.message.receiver", props);
        this.xaTransactedMessageReceiver = this.removeProperty("xa.transacted.message.receiver", props);
        this.messageAdapter = this.removeProperty("message.adapter", props);
        this.defaultInboundTransformer = this.removeProperty("inbound.transformer", props);
        this.defaultOutboundTransformer = this.removeProperty("outbound.transformer", props);
        this.defaultResponseTransformer = this.removeProperty("response.transformer", props);
        this.endpointBuilder = this.removeProperty("endpoint.builder", props);
        this.sessionHandler = this.removeProperty("session.handler", props);
    }

    public void setOverrides(Properties props) {
        if (props == null || props.size() == 0) {
            return;
        }
        this.connector = props.getProperty("connector", this.connector);
        this.connectorFactory = props.getProperty("connector.factory", this.connectorFactory);
        this.dispatcherFactory = props.getProperty("dispatcher.factory", this.dispatcherFactory);
        this.requesterFactory = props.getProperty("requester.factory", this.requesterFactory);
        this.messageReceiver = props.getProperty("message.receiver", this.messageReceiver);
        this.transactedMessageReceiver = props.getProperty("transacted.message.receiver", this.transactedMessageReceiver);
        this.xaTransactedMessageReceiver = props.getProperty("xa.transacted.message.receiver", this.xaTransactedMessageReceiver);
        this.messageAdapter = props.getProperty("message.adapter", this.messageAdapter);
        String temp = props.getProperty("inbound.transformer");
        if (temp != null) {
            this.defaultInboundTransformer = temp;
            this.inboundTransformer = null;
        }
        if ((temp = props.getProperty("outbound.transformer")) != null) {
            this.defaultOutboundTransformer = temp;
            this.outboundTransformer = null;
        }
        if ((temp = props.getProperty("response.transformer")) != null) {
            this.defaultResponseTransformer = temp;
            this.responseTransformer = null;
        }
        if ((temp = props.getProperty("endpoint.builder")) != null) {
            this.endpointBuilder = temp;
        }
    }

    public UMOMessageAdapter createMessageAdapter(Object message) throws TransportServiceException {
        return this.createMessageAdapter(message, this.messageAdapter);
    }

    protected UMOMessageAdapter createMessageAdapter(Object message, String clazz) throws TransportServiceException {
        if (message == null) {
            message = NullPayload.getInstance();
        }
        if (this.messageAdapter != null) {
            try {
                return (UMOMessageAdapter)ClassUtils.instanciateClass(clazz, new Object[]{message});
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Adapter", clazz), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Adapter", this.getService()));
    }

    public UMOSessionHandler createSessionHandler() throws TransportServiceException {
        if (this.sessionHandler == null) {
            this.sessionHandler = MuleSessionHandler.class.getName();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No session.handler set in service description, defaulting to: " + this.sessionHandler));
            }
        }
        try {
            return (UMOSessionHandler)ClassUtils.instanciateClass(this.sessionHandler, ClassUtils.NO_ARGS, this.getClass());
        }
        catch (Throwable e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("SessionHandler", this.sessionHandler), e);
        }
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOImmutableEndpoint endpoint) throws UMOException {
        return this.createMessageReceiver(connector, component, endpoint, null);
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOImmutableEndpoint endpoint, Object[] args) throws UMOException {
        String receiverClass = this.messageReceiver;
        if (endpoint.getTransactionConfig() != null && endpoint.getTransactionConfig().getAction() != 0) {
            boolean xaTx = endpoint.getTransactionConfig().getFactory() instanceof XaTransactionFactory;
            if (this.transactedMessageReceiver != null && !xaTx) {
                receiverClass = this.transactedMessageReceiver;
            } else if (this.xaTransactedMessageReceiver != null && xaTx) {
                receiverClass = this.xaTransactedMessageReceiver;
            }
        }
        if (receiverClass != null) {
            Object[] newArgs = args != null && args.length != 0 ? new Object[3 + args.length] : new Object[]{connector, component, endpoint};
            if (args != null && args.length != 0) {
                System.arraycopy(args, 0, newArgs, 3, newArgs.length - 3);
            }
            try {
                return (UMOMessageReceiver)ClassUtils.instanciateClass(receiverClass, newArgs);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Receiver", this.getService()), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Receiver", this.getService()));
    }

    public UMOMessageDispatcherFactory createDispatcherFactory() throws TransportServiceException {
        if (this.dispatcherFactory != null) {
            try {
                return (UMOMessageDispatcherFactory)ClassUtils.instanciateClass(this.dispatcherFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Dispatcher Factory", this.dispatcherFactory), (Throwable)e);
            }
        }
        return null;
    }

    public UMOMessageRequesterFactory createRequesterFactory() throws TransportServiceException {
        if (this.requesterFactory != null) {
            try {
                return (UMOMessageRequesterFactory)ClassUtils.instanciateClass(this.requesterFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Requester Factory", this.requesterFactory), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransactionFactory createTransactionFactory() throws TransportServiceException {
        if (this.transactionFactory != null) {
            try {
                return (UMOTransactionFactory)ClassUtils.instanciateClass(this.transactionFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Transaction Factory", this.transactionFactory), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public UMOConnector createConnector() throws TransportServiceException {
        void var1_4;
        block6: {
            try {
                UMOConnector newConnector;
                if (this.connectorFactory != null) {
                    ObjectFactory factory = (ObjectFactory)ClassUtils.loadClass(this.connectorFactory, TransportFactory.class).newInstance();
                    newConnector = (UMOConnector)factory.getOrCreate();
                    break block6;
                }
                if (this.connector != null) {
                    newConnector = (UMOConnector)ClassUtils.loadClass(this.connector, TransportFactory.class).newInstance();
                    break block6;
                }
                throw new TransportServiceException(CoreMessages.objectNotSetInService("Connector", this.getService()));
            }
            catch (TransportServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Connector", this.connector), (Throwable)e);
            }
        }
        if (var1_4.getName() == null) {
            var1_4.setName("_" + var1_4.getProtocol() + "Connector#" + this.connector.hashCode());
        }
        return var1_4;
    }

    public List createInboundTransformers() throws TransportFactoryException {
        if (this.inboundTransformer != null) {
            return CollectionUtils.singletonList(this.inboundTransformer);
        }
        if (this.defaultInboundTransformer != null) {
            this.logger.info((Object)("Loading default inbound transformer: " + this.defaultInboundTransformer));
            try {
                this.inboundTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.defaultInboundTransformer, ClassUtils.NO_ARGS);
                return CollectionUtils.singletonList(this.inboundTransformer);
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("inbound", this.defaultInboundTransformer), (Throwable)e);
            }
        }
        return TransformerUtils.UNDEFINED;
    }

    public List createOutboundTransformers() throws TransportFactoryException {
        if (this.outboundTransformer != null) {
            return CollectionUtils.singletonList(this.outboundTransformer);
        }
        if (this.defaultOutboundTransformer != null) {
            this.logger.info((Object)("Loading default outbound transformer: " + this.defaultOutboundTransformer));
            try {
                this.outboundTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.defaultOutboundTransformer, ClassUtils.NO_ARGS);
                return CollectionUtils.singletonList(this.outboundTransformer);
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("outbound", this.defaultOutboundTransformer), (Throwable)e);
            }
        }
        return TransformerUtils.UNDEFINED;
    }

    public List createResponseTransformers() throws TransportFactoryException {
        if (this.responseTransformer != null) {
            return CollectionUtils.singletonList(this.responseTransformer);
        }
        if (this.defaultResponseTransformer != null) {
            this.logger.info((Object)("Loading default response transformer: " + this.defaultResponseTransformer));
            try {
                this.responseTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.defaultResponseTransformer, ClassUtils.NO_ARGS);
                return CollectionUtils.singletonList(this.responseTransformer);
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("response", this.defaultResponseTransformer), (Throwable)e);
            }
        }
        return TransformerUtils.UNDEFINED;
    }

    public EndpointURIBuilder createEndpointBuilder() throws TransportFactoryException {
        if (this.endpointBuilder == null) {
            this.logger.debug((Object)("Endpoint resolver not set, Loading default resolver: " + UrlEndpointURIBuilder.class.getName()));
            return new UrlEndpointURIBuilder();
        }
        this.logger.debug((Object)("Loading endpointUri resolver: " + this.endpointBuilder));
        try {
            return (EndpointURIBuilder)ClassUtils.instanciateClass(this.endpointBuilder, ClassUtils.NO_ARGS);
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToLoad("Endpoint Builder: " + this.endpointBuilder), (Throwable)e);
        }
    }

    public void setExceptionMappings(Properties props) {
        this.exceptionMappings = props;
    }

    public Properties getExceptionMappings() {
        return this.exceptionMappings;
    }
}

