/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.NullPayload;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMutableMessageAdapter;

public final class DefaultMessageAdapter
extends AbstractMessageAdapter
implements UMOMutableMessageAdapter {
    private static final long serialVersionUID = 1908152148142575505L;
    protected Object message;

    protected DefaultMessageAdapter() {
    }

    public DefaultMessageAdapter(Object message) {
        this.message = message == null ? NullPayload.getInstance() : message;
    }

    public DefaultMessageAdapter(Object message, UMOMessageAdapter previous) {
        super(previous);
        if (previous != null) {
            String name;
            this.message = message == null ? NullPayload.getInstance() : message;
            Iterator iterator = previous.getAttachmentNames().iterator();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                try {
                    DataHandler dh = previous.getAttachment(name);
                    if (null == dh) {
                        logger.warn((Object)("Detected concurrent access to attachment " + name + " for " + previous));
                        continue;
                    }
                    this.addAttachment(name, dh);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
                }
            }
            iterator = previous.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                try {
                    Object value = previous.getProperty(name);
                    if (null == value) {
                        logger.warn((Object)("Detected concurrent access to property " + name + " for " + previous));
                        continue;
                    }
                    this.setProperty(name, value);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("previousAdapter may not be null");
        }
    }

    public DefaultMessageAdapter(Object message, Map properties, Map attachments) {
        this(message);
        if (properties != null) {
            this.properties.addInboundProperties(properties);
        }
        if (attachments != null) {
            this.attachments.putAll(attachments);
        }
    }

    public Object getPayload() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(Object payload) {
        Object object = this.message;
        synchronized (object) {
            this.message = payload;
        }
    }

    public String getUniqueId() {
        return this.id;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new DefaultMessageAdapter(this.getPayload(), this);
    }
}

