/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import org.mule.impl.internal.notifications.MessageNotification;
import org.mule.providers.AbstractConnectable;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOMessageRequester;

public abstract class AbstractMessageRequester
extends AbstractConnectable
implements UMOMessageRequester {
    public AbstractMessageRequester(UMOImmutableEndpoint endpoint) {
        super(endpoint);
    }

    public final UMOMessage request(long timeout) throws Exception {
        try {
            this.connectionStrategy.connect(this);
            UMOMessage result = this.doRequest(timeout);
            if (result != null && this.connector.isEnableMessageEvents()) {
                this.connector.fireNotification(new MessageNotification(result, this.endpoint, null, 801));
            }
            return result;
        }
        catch (DispatchException e) {
            this.disposeAndLogException();
            throw e;
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new ReceiveException(this.endpoint, timeout, e);
        }
    }

    protected abstract UMOMessage doRequest(long var1) throws Exception;
}

