/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security.filters;

import org.mule.config.i18n.CoreMessages;
import org.mule.impl.security.AbstractEndpointSecurityFilter;
import org.mule.impl.security.MuleAuthentication;
import org.mule.impl.security.MuleCredentials;
import org.mule.impl.security.MuleHeaderCredentialsAccessor;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.UMOEvent;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.CredentialsNotSetException;
import org.mule.umo.security.CryptoFailureException;
import org.mule.umo.security.EncryptionStrategyNotFoundException;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.SecurityProviderNotFoundException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UnauthorisedException;
import org.mule.umo.security.UnknownAuthenticationTypeException;

public class MuleEncryptionEndpointSecurityFilter
extends AbstractEndpointSecurityFilter {
    private UMOEncryptionStrategy strategy;

    public MuleEncryptionEndpointSecurityFilter() {
        this.setCredentialsAccessor(new MuleHeaderCredentialsAccessor());
    }

    protected final void authenticateInbound(UMOEvent event) throws SecurityException, CryptoFailureException, EncryptionStrategyNotFoundException, UnknownAuthenticationTypeException {
        UMOAuthentication authResult;
        String userHeader = (String)this.getCredentialsAccessor().getCredentials(event);
        if (userHeader == null) {
            throw new CredentialsNotSetException(event.getMessage(), event.getSession().getSecurityContext(), event.getEndpoint(), this);
        }
        MuleCredentials user = new MuleCredentials(userHeader, this.getSecurityManager());
        MuleAuthentication umoAuthentication = new MuleAuthentication(user);
        try {
            authResult = this.getSecurityManager().authenticate(umoAuthentication);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication request for user: " + user.getUsername() + " failed: " + e.toString()));
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser(user.getUsername()), event.getMessage(), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        UMOSecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        context.setAuthentication(authResult);
        event.getSession().setSecurityContext(context);
    }

    protected void authenticateOutbound(UMOEvent event) throws SecurityException, SecurityProviderNotFoundException, CryptoFailureException {
        if (event.getSession().getSecurityContext() == null) {
            if (this.isAuthenticate()) {
                throw new UnauthorisedException(event.getMessage(), event.getSession().getSecurityContext(), event.getEndpoint(), this);
            }
            return;
        }
        UMOAuthentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (this.isAuthenticate()) {
            auth = this.getSecurityManager().authenticate(auth);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication success: " + auth.toString()));
            }
        }
        String token = auth.getCredentials().toString();
        String header = new String(this.strategy.encrypt(token.getBytes(), null));
        this.getCredentialsAccessor().setCredentials(event, header);
    }

    protected void doInitialise() throws InitialisationException {
        if (this.strategy == null) {
            throw new InitialisationException(CoreMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public UMOEncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UMOEncryptionStrategy strategy) {
        this.strategy = strategy;
    }
}

