/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.registry;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContextAware;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.transformers.AbstractTransformer;
import org.mule.transformers.TransformerCollection;
import org.mule.transformers.TransformerWeighting;
import org.mule.transformers.simple.ObjectToByteArray;
import org.mule.transformers.simple.ObjectToString;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointFactory;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.DiscoverableTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.CollectionUtils;
import org.mule.util.UUID;
import org.mule.util.properties.PropertyExtractorManager;

public abstract class AbstractRegistry
implements Registry {
    private static final ObjectToString objectToString = new ObjectToString();
    private static final ObjectToByteArray objectToByteArray = new ObjectToByteArray();
    private Registry parent;
    private String id;
    private int defaultScope = 2;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOLifecycleManager lifecycleManager;
    protected Map transformerListCache = new ConcurrentHashMap(8);
    protected Map exactTransformerCache = new ConcurrentHashMap(8);

    protected AbstractRegistry(String id) {
        if (id == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("RegistryID").getMessage());
        }
        this.id = id;
        this.lifecycleManager = this.createLifecycleManager();
    }

    protected AbstractRegistry(String id, Registry parent) {
        this(id);
        this.setParent(parent);
    }

    protected abstract UMOLifecycleManager createLifecycleManager();

    protected UMOLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public final synchronized void dispose() {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.exactTransformerCache.clear();
            this.transformerListCache.clear();
            this.doDispose();
            this.lifecycleManager.firePhase(MuleServer.getManagementContext(), "dispose");
            if (this.getParent() != null) {
                this.parent.dispose();
            } else {
                RegistryContext.setRegistry(null);
                PropertyExtractorManager.clear();
            }
        }
        catch (UMOException e) {
            this.logger.error((Object)("Failed to cleanly dispose: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void doDispose() {
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "initialise".equals(this.lifecycleManager.getExecutingPhase());
    }

    public final void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.id == null) {
            this.logger.warn((Object)"No unique id has been set on this registry");
            this.id = UUID.getUUID();
        }
        try {
            this.doInitialise();
            this.lifecycleManager.firePhase(MuleServer.getManagementContext(), "initialise");
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    public UMOConnector lookupConnector(String name) {
        return (UMOConnector)this.lookupObject(name);
    }

    public UMOImmutableEndpoint lookupEndpoint(String name) {
        Object obj = this.lookupObject(name);
        if (obj instanceof UMOImmutableEndpoint) {
            return (UMOImmutableEndpoint)obj;
        }
        this.logger.debug((Object)("No endpoint with the name: " + name + "found.  If " + name + " is a global endpoint you should use the EndpointFactory to create endpoint instances from global endpoints."));
        return null;
    }

    public UMOEndpointBuilder lookupEndpointBuilder(String name) {
        Object o = this.lookupObject(name);
        if (o instanceof UMOEndpointBuilder) {
            this.logger.debug((Object)("Global endpoint EndpointBuilder for name: " + name + "found"));
            return (UMOEndpointBuilder)o;
        }
        this.logger.debug((Object)("No endpoint builder with the name: " + name + "found."));
        return null;
    }

    public UMOEndpointFactory lookupEndpointFactory() {
        return (UMOEndpointFactory)this.lookupObject("_muleEndpointFactory");
    }

    public UMOTransformer lookupTransformer(String name) {
        return (UMOTransformer)this.lookupObject(name);
    }

    public UMOTransformer lookupTransformer(Class inputType, Class outputType) throws TransformerException {
        UMOTransformer result = (UMOTransformer)this.exactTransformerCache.get(inputType.getName() + outputType.getName());
        if (result != null) {
            return result;
        }
        List trans = this.lookupTransformers(inputType, outputType);
        result = this.getNearestTransformerMatch(trans, inputType, outputType);
        AbstractTransformer secondPass = null;
        if (result == null) {
            if (outputType.equals(String.class)) {
                secondPass = objectToString;
            } else if (outputType.equals([B.class)) {
                secondPass = objectToByteArray;
            } else {
                throw new TransformerException(CoreMessages.noTransformerFoundForMessage(inputType, outputType));
            }
            trans = this.lookupTransformers(inputType, Object.class);
            result = this.getNearestTransformerMatch(trans, inputType, outputType);
            if (result != null) {
                result = new TransformerCollection(new UMOTransformer[]{result, secondPass});
            }
        }
        if (result != null) {
            this.exactTransformerCache.put(inputType.getName() + outputType.getName(), result);
        }
        return result;
    }

    protected UMOTransformer getNearestTransformerMatch(List trans, Class input, Class output) throws TransformerException {
        if (trans.size() > 1) {
            TransformerWeighting weighting = null;
            Iterator iterator = trans.iterator();
            while (iterator.hasNext()) {
                UMOTransformer transformer = (UMOTransformer)iterator.next();
                TransformerWeighting current = new TransformerWeighting(input, output, transformer);
                if (weighting == null) {
                    weighting = current;
                    continue;
                }
                int compare = current.compareTo(weighting);
                if (compare == 1) {
                    weighting = current;
                    continue;
                }
                if (compare != 0 || weighting.getTransformer().getClass().equals(current.getTransformer().getClass())) continue;
                throw new TransformerException(CoreMessages.transformHasMultipleMatches(input, output, current.getTransformer(), weighting.getTransformer()));
            }
            return weighting.getTransformer();
        }
        if (trans.size() == 0) {
            return null;
        }
        return (UMOTransformer)trans.get(0);
    }

    public List lookupTransformers(Class input, Class output) {
        ArrayList<UMOTransformer> results = (ArrayList<UMOTransformer>)this.transformerListCache.get(input.getName() + output.getName());
        if (results != null) {
            return results;
        }
        results = new ArrayList<UMOTransformer>(2);
        Collection transformers = this.getTransformers();
        Iterator itr = transformers.iterator();
        while (itr.hasNext()) {
            UMOTransformer t = (UMOTransformer)itr.next();
            if (!(t instanceof DiscoverableTransformer)) continue;
            Class c = t.getReturnClass();
            if (c == null) {
                Class clazz = c = class$java$lang$Object == null ? AbstractRegistry.class$("java.lang.Object") : class$java$lang$Object;
            }
            if (!output.isAssignableFrom(c) || !t.isSourceTypeSupported(input)) continue;
            results.add(t);
        }
        this.transformerListCache.put(input.getName() + output.getName(), results);
        return results;
    }

    public UMOModel lookupModel(String name) {
        return (UMOModel)this.lookupObject(name);
    }

    public UMOModel lookupSystemModel() {
        return this.lookupModel("_muleSystemModel");
    }

    public Collection getModels() {
        return this.lookupObjects(UMOModel.class);
    }

    public Collection getConnectors() {
        return this.lookupObjects(UMOConnector.class);
    }

    public Collection getAgents() {
        return this.lookupObjects(UMOAgent.class);
    }

    public Collection getEndpoints() {
        return this.lookupObjects(UMOImmutableEndpoint.class);
    }

    public Collection getTransformers() {
        return this.lookupObjects(UMOTransformer.class);
    }

    public UMOAgent lookupAgent(String name) {
        return (UMOAgent)this.lookupObject(name);
    }

    public UMOComponent lookupComponent(String name) {
        return (UMOComponent)this.lookupObject(name);
    }

    public Collection lookupComponents() {
        return this.lookupObjects(UMOComponent.class);
    }

    public Collection lookupComponents(String model) {
        Collection components = this.lookupComponents();
        ArrayList<UMOComponent> modelComponents = new ArrayList<UMOComponent>();
        Iterator it = components.iterator();
        while (it.hasNext()) {
            UMOComponent component = (UMOComponent)it.next();
            if (!model.equals(component.getModel().getName())) continue;
            modelComponents.add(component);
        }
        return modelComponents;
    }

    public final Object lookupObject(String key, int scope) {
        this.logger.debug((Object)("lookupObject: key=" + key + " scope=" + scope));
        Object o = this.doLookupObject(key);
        if (o == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to find object in Registry ID: " + this.getRegistryId()));
            }
            if (this.getParent() != null && scope > 0) {
                if (this.getParent().isRemote() && scope == 2) {
                    o = this.getParent().lookupObject(key);
                } else if (!this.getParent().isRemote() && scope >= 1) {
                    o = this.getParent().lookupObject(key);
                }
            }
        }
        return o;
    }

    public final Object lookupObject(Class type) throws RegistrationException {
        return this.lookupObject(type, this.getDefaultScope());
    }

    public final Object lookupObject(Class type, int scope) throws RegistrationException {
        Collection collection = this.lookupObjects(type, scope);
        if (collection == null || collection.size() < 1) {
            return null;
        }
        if (collection.size() > 1) {
            throw new RegistrationException("More than one object of type " + type + " was found in registry, but only 1 was expected.");
        }
        return collection.iterator().next();
    }

    public final Collection lookupObjects(Class type) {
        return this.lookupObjects(type, this.getDefaultScope());
    }

    public final Collection lookupObjects(Class type, int scope) {
        this.logger.debug((Object)("lookupObjects: type=" + type + " scope=" + scope));
        Collection collection = this.doLookupObjects(type);
        if (collection == null) {
            collection = new ArrayList();
        }
        if (this.getParent() != null && scope > 0) {
            Collection collection2;
            if (this.getParent().isRemote() && scope == 2) {
                Collection collection22 = this.getParent().lookupObjects(type);
                if (collection22 != null) {
                    collection.addAll(collection22);
                }
            } else if (!this.getParent().isRemote() && scope >= 1 && (collection2 = this.getParent().lookupObjects(type)) != null) {
                collection = CollectionUtils.union(collection, (Collection)collection2);
            }
        }
        return collection;
    }

    protected abstract Collection doLookupObjects(Class var1);

    public Object lookupObject(String key) {
        return this.lookupObject(key, this.getDefaultScope());
    }

    protected abstract Object doLookupObject(String var1);

    protected void unsupportedOperation(String operation, Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Registry: " + this.getRegistryId() + " is read-only so objects cannot be registered or unregistered. Failed to execute operation " + operation + " on object: " + o);
    }

    public final void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, null);
    }

    public final void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.logger.debug((Object)("registerObject: key=" + key + " value=" + value + " metadata=" + metadata));
        if (value instanceof ManagementContextAware) {
            ((ManagementContextAware)value).setManagementContext(MuleServer.getManagementContext());
        }
        this.doRegisterObject(key, value, metadata);
    }

    protected abstract void doRegisterObject(String var1, Object var2, Object var3) throws RegistrationException;

    public final void registerTransformer(UMOTransformer transformer) throws UMOException {
        if (transformer instanceof DiscoverableTransformer) {
            this.exactTransformerCache.clear();
            this.transformerListCache.clear();
        }
        this.doRegisterTransformer(transformer);
    }

    protected abstract void doRegisterTransformer(UMOTransformer var1) throws UMOException;

    public final MuleConfiguration getConfiguration() {
        MuleConfiguration config = this.getLocalConfiguration();
        if (config == null && this.getParent() != null) {
            config = this.getParent().getConfiguration();
        }
        if (config == null) {
            config = new MuleConfiguration();
            this.setConfiguration(config);
        }
        return config;
    }

    protected MuleConfiguration getLocalConfiguration() {
        Collection collection = this.lookupObjects(MuleConfiguration.class);
        if (collection == null) {
            this.logger.warn((Object)"No MuleConfiguration was found in registry");
            return null;
        }
        if (collection.size() > 1) {
            this.logger.warn((Object)"More than one MuleConfiguration was found in registry");
        }
        return (MuleConfiguration)collection.iterator().next();
    }

    public final String getRegistryId() {
        return this.id;
    }

    public Registry getParent() {
        return this.parent;
    }

    public void setParent(Registry registry) {
        this.parent = registry;
    }

    public int getDefaultScope() {
        return this.defaultScope;
    }

    public void setDefaultScope(int scope) {
        if (scope < 0 || scope > 2) {
            throw new IllegalArgumentException("Invalid value for scope: " + scope);
        }
        this.defaultScope = scope;
    }
}

