/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.resolvers;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.model.resolvers.EntryPointNotFoundException;
import org.mule.umo.UMOEventContext;
import org.mule.umo.model.InvocationResult;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOEntryPointResolverSet;
import org.mule.util.CollectionUtils;

public class DefaultEntryPointResolverSet
implements UMOEntryPointResolverSet {
    protected final transient Log logger = LogFactory.getLog((Class)DefaultEntryPointResolverSet.class);
    private final Set entryPointResolvers = new LinkedHashSet(4);
    private List exceptions = new CopyOnWriteArrayList();

    public Object invoke(Object component, UMOEventContext context) throws Exception {
        try {
            Iterator iterator = this.entryPointResolvers.iterator();
            while (iterator.hasNext()) {
                UMOEntryPointResolver resolver = (UMOEntryPointResolver)iterator.next();
                InvocationResult result = resolver.invoke(component, context);
                if (result.getState() == 1) {
                    Object object = result.getResult();
                    return object;
                }
                if (!result.hasError()) continue;
                this.exceptions.add(result.getErrorMessage());
            }
            throw new EntryPointNotFoundException(CollectionUtils.toString((Collection)this.exceptions, true));
        }
        finally {
            this.exceptions.clear();
        }
    }

    public Set getEntryPointResolvers() {
        return this.entryPointResolvers;
    }

    public void setEntryPointResolvers(Set entryPointResolvers) {
        this.entryPointResolvers.clear();
        this.entryPointResolvers.addAll(entryPointResolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntryPointResolver(UMOEntryPointResolver resolver) {
        Set set = this.entryPointResolvers;
        synchronized (set) {
            this.entryPointResolvers.add(resolver);
        }
    }

    public boolean removeEntryPointResolver(UMOEntryPointResolver resolver) {
        return this.entryPointResolvers.remove(resolver);
    }
}

