/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import java.util.Properties;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.model.ModelFactory;
import org.mule.impl.model.ModelServiceDescriptor;
import org.mule.registry.AbstractServiceDescriptor;
import org.mule.registry.ServiceException;
import org.mule.umo.model.UMOModel;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

public class DefaultModelServiceDescriptor
extends AbstractServiceDescriptor
implements ModelServiceDescriptor {
    private String modelClass;
    private Properties properties;

    public DefaultModelServiceDescriptor(String service, Properties properties) {
        super(service);
        this.properties = properties;
        this.modelClass = this.removeProperty("model", properties);
    }

    public UMOModel createModel() throws ServiceException {
        if (this.modelClass != null) {
            try {
                UMOModel model = (UMOModel)ClassUtils.instanciateClass(this.modelClass, ClassUtils.NO_ARGS, ModelFactory.class);
                BeanUtils.populateWithoutFail(model, this.properties, false);
                return model;
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.failedToCreate(this.modelClass), (Throwable)e);
            }
        }
        return null;
    }

    public Class getModelClass() throws ServiceException {
        try {
            return ClassUtils.getClass((String)this.modelClass);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(CoreMessages.cannotLoadFromClasspath(this.modelClass), (Throwable)e);
        }
    }
}

