/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.components.simple.PassThroughComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.InitialisationCallback;
import org.mule.impl.ManagementContextAware;
import org.mule.impl.OptimizedRequestContext;
import org.mule.impl.internal.notifications.ComponentNotification;
import org.mule.impl.model.DefaultMuleProxy;
import org.mule.impl.model.MuleProxy;
import org.mule.management.stats.ComponentStatistics;
import org.mule.providers.AbstractConnector;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.routing.inbound.InboundRouterCollection;
import org.mule.routing.nested.NestedRouterCollection;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.routing.outbound.OutboundRouterCollection;
import org.mule.routing.response.ResponseRouterCollection;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOEntryPointResolverSet;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMONestedRouterCollection;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.routing.UMOResponseRouterCollection;
import org.mule.util.concurrent.WaitableBoolean;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.SingletonObjectFactory;

public abstract class AbstractComponent
implements UMOComponent {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ComponentStatistics stats = null;
    protected AtomicBoolean stopped = new AtomicBoolean(true);
    protected WaitableBoolean stopping = new WaitableBoolean(false);
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected UMOModel model;
    protected WaitableBoolean paused = new WaitableBoolean(false);
    protected UMOManagementContext managementContext;
    protected UMOEntryPointResolverSet entryPointResolverSet;
    public static final String INITIAL_STATE_STOPPED = "stopped";
    public static final String INITIAL_STATE_STARTED = "started";
    public static final String INITIAL_STATE_PAUSED = "paused";
    protected ExceptionListener exceptionListener;
    protected ObjectFactory serviceFactory = new SingletonObjectFactory(PassThroughComponent.class);
    protected String name;
    protected UMOInboundRouterCollection inboundRouter = new InboundRouterCollection();
    protected UMOOutboundRouterCollection outboundRouter = new OutboundRouterCollection();
    protected UMONestedRouterCollection nestedRouter = new NestedRouterCollection();
    protected UMOResponseRouterCollection responseRouter = new ResponseRouterCollection();
    protected String initialState = "started";
    protected List initialisationCallbacks = new ArrayList();
    private AtomicBoolean beyondInitialState = new AtomicBoolean(false);
    protected Map properties = new HashMap();

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new InitialisationException(CoreMessages.objectAlreadyInitialised("Component '" + this.name + "'"), (Initialisable)this);
        }
        if (this.inboundRouter == null) {
            this.inboundRouter = new InboundRouterCollection();
            this.inboundRouter.addRouter(new InboundPassThroughRouter());
        }
        if (this.outboundRouter == null) {
            this.outboundRouter = new OutboundRouterCollection();
            this.outboundRouter.addRouter(new OutboundPassThroughRouter());
        }
        if (this.responseRouter == null) {
            this.responseRouter = new ResponseRouterCollection();
        }
        if (this.nestedRouter == null) {
            this.nestedRouter = new NestedRouterCollection();
        }
        if (this.exceptionListener == null) {
            this.exceptionListener = new DefaultComponentExceptionStrategy(this);
            ((ManagementContextAware)((Object)this.exceptionListener)).setManagementContext(this.managementContext);
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
        this.serviceFactory.initialise();
        this.doInitialise();
        this.stats = this.createStatistics();
        this.stats.setEnabled(this.managementContext.getStatistics().isEnabled());
        this.managementContext.getStatistics().add(this.stats);
        this.stats.setOutboundRouterStat(this.outboundRouter.getStatistics());
        this.stats.setInboundRouterStat(this.inboundRouter.getStatistics());
        this.initialised.set(true);
        this.fireComponentNotification(301);
    }

    protected ComponentStatistics createStatistics() {
        return new ComponentStatistics(this.name);
    }

    protected void fireComponentNotification(int action) {
        this.managementContext.fireNotification(new ComponentNotification(this, action));
    }

    public void forceStop() throws UMOException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            this.doForceStop();
            this.stopped.set(true);
            this.stopping.set(false);
            this.fireComponentNotification(303);
        }
    }

    public void stop() throws UMOException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            this.unregisterListeners();
            if (this.managementContext.getQueueManager().getQueueSession().getQueue(this.name + ".component").size() > 0) {
                try {
                    this.stopping.whenFalse(null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doStop();
            this.stopped.set(true);
            this.initialised.set(false);
            this.fireComponentNotification(303);
            this.logger.info((Object)("Mule Component " + this.name + " has been stopped successfully"));
        }
    }

    public void start() throws UMOException {
        if (this.isStarted()) {
            this.logger.info((Object)("Component is already started: " + this.name));
            return;
        }
        if (!this.beyondInitialState.get() && this.initialState.equals(INITIAL_STATE_STOPPED)) {
            this.logger.info((Object)("Component " + this.name + " has not been started (initial state = 'stopped')"));
        } else if (!this.beyondInitialState.get() && this.initialState.equals(INITIAL_STATE_PAUSED)) {
            this.start(true);
            this.logger.info((Object)("Component " + this.name + " has been started and paused (initial state = 'paused')"));
        } else {
            this.start(false);
            this.logger.info((Object)("Component " + this.name + " has been started successfully"));
        }
        this.beyondInitialState.set(true);
    }

    protected void start(boolean startPaused) throws UMOException {
        this.registerListeners();
        this.connectListeners();
        if (this.stopped.get()) {
            this.stopped.set(false);
            this.paused.set(false);
            this.doStart();
        }
        this.fireComponentNotification(302);
        if (startPaused) {
            this.pause();
        }
        this.startListeners();
    }

    public final void pause() throws UMOException {
        this.doPause();
        this.paused.set(true);
        this.fireComponentNotification(304);
        this.logger.info((Object)("Mule Component " + this.name + " has been paused successfully"));
    }

    public final void resume() throws UMOException {
        this.doResume();
        this.paused.set(false);
        this.fireComponentNotification(305);
        this.logger.info((Object)("Mule Component " + this.name + " has been resumed successfully"));
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    protected void doPause() throws UMOException {
    }

    protected void doResume() throws UMOException {
    }

    public final void dispose() {
        try {
            if (!this.stopped.get()) {
                this.stop();
            }
        }
        catch (UMOException e) {
            this.logger.error((Object)("Failed to stop component: " + this.name), (Throwable)e);
        }
        this.doDispose();
        this.fireComponentNotification(306);
        this.managementContext.getStatistics().remove(this.stats);
    }

    public ComponentStatistics getStatistics() {
        return this.stats;
    }

    public void dispatchEvent(UMOEvent event) throws UMOException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ComponentException(CoreMessages.componentIsStopped(this.name), event.getMessage(), this);
        }
        try {
            this.waitIfPaused(event);
        }
        catch (InterruptedException e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (!endpoint.canRequest()) {
            try {
                endpoint.dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            return;
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.name + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        this.doDispatch(event);
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ComponentException(CoreMessages.componentIsStopped(this.name), event.getMessage(), this);
        }
        try {
            this.waitIfPaused(event);
        }
        catch (InterruptedException e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventSync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.name + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        event = OptimizedRequestContext.unsafeSetEvent(event);
        return this.doSend(event);
    }

    protected void waitIfPaused(UMOEvent event) throws InterruptedException {
        if (this.logger.isDebugEnabled() && this.paused.get()) {
            this.logger.debug((Object)("Component: " + this.name + " is paused. Blocking call until resume is called"));
        }
        this.paused.whenFalse(null);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    protected void handleException(Exception e) {
        if (this.exceptionListener instanceof DefaultComponentExceptionStrategy && ((DefaultComponentExceptionStrategy)this.exceptionListener).getComponent() == null) {
            ((DefaultComponentExceptionStrategy)this.exceptionListener).setComponent(this);
        }
        this.exceptionListener.exceptionThrown(e);
    }

    protected void doForceStop() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected void doStart() throws UMOException {
    }

    protected void doDispose() {
    }

    protected void doInitialise() throws InitialisationException {
    }

    public boolean isStarted() {
        return !this.stopped.get();
    }

    protected abstract UMOMessage doSend(UMOEvent var1) throws UMOException;

    protected abstract void doDispatch(UMOEvent var1) throws UMOException;

    protected void registerListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().registerListener(this, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedtoRegisterOnEndpoint(this.name, endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void unregisterListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().unregisterListener(this, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToUnregister(this.name, endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void startListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null || !endpoint.getConnector().isStarted() || !endpoint.getInitialState().equals(INITIAL_STATE_STARTED)) continue;
            receiver.start();
        }
    }

    protected void stopListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            receiver.stop();
        }
    }

    protected void connectListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            try {
                receiver.connect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to connect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected void disconnectListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            try {
                receiver.disconnect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to disconnect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected List getIncomingEndpoints() {
        ArrayList endpoints = new ArrayList();
        endpoints.addAll(this.inboundRouter.getEndpoints());
        if (this.responseRouter != null && this.responseRouter.getEndpoints() != null) {
            endpoints.addAll(this.responseRouter.getEndpoints());
        }
        return endpoints;
    }

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
    }

    protected MuleProxy createComponentProxy(Object pojoService) throws UMOException {
        DefaultMuleProxy proxy = new DefaultMuleProxy(pojoService, this, this.managementContext);
        proxy.setStatistics(this.getStatistics());
        return proxy;
    }

    protected Object getOrCreateService() throws UMOException {
        Object component;
        if (this.serviceFactory == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Component " + this.name + " has not been initialized properly, no serviceFactory."), (Initialisable)this);
        }
        try {
            component = this.serviceFactory.getOrCreate();
        }
        catch (Exception e) {
            throw new LifecycleException(MessageFactory.createStaticMessage("Unable to create instance of POJO service"), e, this);
        }
        this.fireInitialisationCallbacks(component);
        return component;
    }

    public void fireInitialisationCallbacks(Object component) throws InitialisationException {
        Iterator iterator = this.initialisationCallbacks.iterator();
        while (iterator.hasNext()) {
            InitialisationCallback callback = (InitialisationCallback)iterator.next();
            callback.initialise(component);
        }
    }

    public void addInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    public UMOModel getModel() {
        return this.model;
    }

    public void setModel(UMOModel model) {
        this.model = model;
    }

    public ObjectFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ObjectFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public UMOInboundRouterCollection getInboundRouter() {
        return this.inboundRouter;
    }

    public void setInboundRouter(UMOInboundRouterCollection inboundRouter) {
        this.inboundRouter = inboundRouter;
    }

    public UMONestedRouterCollection getNestedRouter() {
        return this.nestedRouter;
    }

    public void setNestedRouter(UMONestedRouterCollection nestedRouter) {
        this.nestedRouter = nestedRouter;
    }

    public UMOOutboundRouterCollection getOutboundRouter() {
        return this.outboundRouter;
    }

    public void setOutboundRouter(UMOOutboundRouterCollection outboundRouter) {
        this.outboundRouter = outboundRouter;
    }

    public UMOResponseRouterCollection getResponseRouter() {
        return this.responseRouter;
    }

    public void setResponseRouter(UMOResponseRouterCollection responseRouter) {
        this.responseRouter = responseRouter;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public UMOEntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    public void setEntryPointResolverSet(UMOEntryPointResolverSet resolverSet) {
        this.entryPointResolverSet = resolverSet;
    }
}

