/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications.manager;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.impl.internal.notifications.manager.ListenerSubscriptionPair;
import org.mule.impl.internal.notifications.manager.Sender;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;

class Policy {
    private Map eventToSenders = new HashMap();
    private ConcurrentMap knownEventsExact = new ConcurrentHashMap();
    private ConcurrentMap knownEventsSuper = new ConcurrentHashMap();

    Policy(Map interfaceToEvents, Set listenerSubscriptionPairs, Set disabledInterfaces, Set disabledEvents) {
        Iterator pairs = listenerSubscriptionPairs.iterator();
        while (pairs.hasNext()) {
            ListenerSubscriptionPair pair = (ListenerSubscriptionPair)pairs.next();
            UMOServerNotificationListener listener = pair.getListener();
            Iterator interfaces = interfaceToEvents.keySet().iterator();
            while (interfaces.hasNext()) {
                Class iface = (Class)interfaces.next();
                if (!Policy.notASubclassOfAnyClassInSet(disabledInterfaces, iface) || !iface.isAssignableFrom(listener.getClass())) continue;
                Iterator events = ((Collection)interfaceToEvents.get(iface)).iterator();
                while (events.hasNext()) {
                    Class event = (Class)events.next();
                    if (!Policy.notASubclassOfAnyClassInSet(disabledEvents, event)) continue;
                    this.knownEventsExact.put((Object)event, (Object)Boolean.TRUE);
                    this.knownEventsSuper.put((Object)event, (Object)Boolean.TRUE);
                    if (!this.eventToSenders.containsKey(event)) {
                        this.eventToSenders.put(event, new HashSet());
                    }
                    ((Collection)this.eventToSenders.get(event)).add(new Sender(pair));
                }
            }
        }
    }

    protected static boolean notASubclassOfAnyClassInSet(Set set, Class clazz) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Class disabled = (Class)iterator.next();
            if (!disabled.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    protected static boolean notASuperclassOfAnyClassInSet(Set set, Class clazz) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Class disabled = (Class)iterator.next();
            if (!clazz.isAssignableFrom(disabled)) continue;
            return false;
        }
        return true;
    }

    void dispatch(UMOServerNotification notification) {
        Class<?> notfnClass;
        if (null != notification && (!this.knownEventsExact.containsKey(notfnClass = notification.getClass()) || ((Boolean)this.knownEventsExact.get(notfnClass)).booleanValue())) {
            boolean found = false;
            Iterator events = this.eventToSenders.keySet().iterator();
            while (events.hasNext()) {
                Class event = (Class)events.next();
                if (!event.isAssignableFrom(notfnClass)) continue;
                found = true;
                Iterator senders = ((Collection)this.eventToSenders.get(event)).iterator();
                while (senders.hasNext()) {
                    ((Sender)senders.next()).dispatch(notification);
                }
            }
            this.knownEventsExact.put(notfnClass, (Object)found);
        }
    }

    boolean isNotificationEnabled(Class notfnClass) {
        Class event;
        Iterator<Object> events;
        boolean found;
        if (!this.knownEventsSuper.containsKey((Object)notfnClass)) {
            found = false;
            events = this.knownEventsSuper.keySet().iterator();
            while (events.hasNext() && !found) {
                event = (Class)events.next();
                found = (Boolean)this.knownEventsSuper.get((Object)event) != false && notfnClass.isAssignableFrom(event);
            }
            this.knownEventsSuper.put((Object)notfnClass, (Object)found);
        }
        if (!this.knownEventsExact.containsKey((Object)notfnClass)) {
            found = false;
            events = this.eventToSenders.keySet().iterator();
            while (events.hasNext() && !found) {
                event = (Class)events.next();
                found = event.isAssignableFrom(notfnClass);
            }
            this.knownEventsExact.put((Object)notfnClass, (Object)found);
        }
        return (Boolean)this.knownEventsSuper.get((Object)notfnClass) != false || (Boolean)this.knownEventsExact.get((Object)notfnClass) != false;
    }
}

