/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.internal.notifications.manager.ListenerSubscriptionPair;
import org.mule.impl.internal.notifications.manager.Policy;
import org.mule.impl.internal.notifications.manager.ServerNotificationManager;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;

class Configuration {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Map interfaceToTypes = new HashMap();
    private Set listenerSubscriptionPairs = new HashSet();
    private Set disabledInterfaces = new HashSet();
    private Set disabledNotificationTypes = new HashSet();
    private boolean dirty = true;
    private Policy policy;

    Configuration() {
    }

    synchronized void addInterfaceToType(Class iface, Class type) {
        this.dirty = true;
        if (!UMOServerNotification.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(CoreMessages.propertyIsNotSupportedType("type", UMOServerNotification.class, type).getMessage());
        }
        if (!this.interfaceToTypes.containsKey(iface)) {
            this.interfaceToTypes.put(iface, new HashSet());
        }
        Set events = (Set)this.interfaceToTypes.get(iface);
        events.add(type);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registered event type: " + type));
            this.logger.debug((Object)("Binding listener type '" + iface + "' to event type '" + type + "'"));
        }
    }

    synchronized void addAllInterfaceToTypes(Map interfaceToTypes) throws ClassNotFoundException {
        this.dirty = true;
        Iterator ifaces = interfaceToTypes.keySet().iterator();
        while (ifaces.hasNext()) {
            Object iface = ifaces.next();
            this.addInterfaceToType(ServerNotificationManager.toClass(iface), ServerNotificationManager.toClass(interfaceToTypes.get(iface)));
        }
    }

    synchronized void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.dirty = true;
        this.listenerSubscriptionPairs.add(pair);
    }

    synchronized void addAllListenerSubscriptionPairs(Collection pairs) {
        this.dirty = true;
        Iterator listener = pairs.iterator();
        while (listener.hasNext()) {
            this.addListenerSubscriptionPair((ListenerSubscriptionPair)listener.next());
        }
    }

    synchronized void removeListener(UMOServerNotificationListener listener) {
        this.dirty = true;
        HashSet<ListenerSubscriptionPair> toRemove = new HashSet<ListenerSubscriptionPair>();
        Iterator listeners = this.listenerSubscriptionPairs.iterator();
        while (listeners.hasNext()) {
            ListenerSubscriptionPair pair = (ListenerSubscriptionPair)listeners.next();
            if (!pair.getListener().equals(listener)) continue;
            toRemove.add(pair);
        }
        this.listenerSubscriptionPairs.removeAll(toRemove);
    }

    synchronized void removeAllListeners(Collection listeners) {
        this.dirty = true;
        Iterator listener = listeners.iterator();
        while (listener.hasNext()) {
            this.removeListener((UMOServerNotificationListener)listener.next());
        }
    }

    synchronized void disableInterface(Class iface) {
        this.dirty = true;
        this.disabledInterfaces.add(iface);
    }

    synchronized void disabledAllInterfaces(Collection interfaces) throws ClassNotFoundException {
        this.dirty = true;
        Iterator iface = interfaces.iterator();
        while (iface.hasNext()) {
            this.disableInterface(ServerNotificationManager.toClass(iface.next()));
        }
    }

    synchronized void disableType(Class type) {
        this.dirty = true;
        this.disabledNotificationTypes.add(type);
    }

    synchronized void disableAllTypes(Collection types) throws ClassNotFoundException {
        this.dirty = true;
        Iterator event = types.iterator();
        while (event.hasNext()) {
            this.disableType(ServerNotificationManager.toClass(event.next()));
        }
    }

    synchronized Policy getPolicy() {
        if (this.dirty) {
            this.policy = new Policy(this.interfaceToTypes, this.listenerSubscriptionPairs, this.disabledInterfaces, this.disabledNotificationTypes);
            this.dirty = false;
        }
        return this.policy;
    }

    Map getInterfaceToTypes() {
        return Collections.unmodifiableMap(this.interfaceToTypes);
    }

    Collection getListeners() {
        return Collections.unmodifiableCollection(this.listenerSubscriptionPairs);
    }
}

