/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.provider.UMOConnectable;

public class MessageNotification
extends UMOServerNotification {
    private static final long serialVersionUID = -5118299601117624094L;
    protected static final Log logger = LogFactory.getLog((Class)MessageNotification.class);
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_DISPATCHED = 802;
    public static final int MESSAGE_SENT = 803;
    public static final int MESSAGE_REQUESTED = 804;
    private UMOImmutableEndpoint endpoint;

    public MessageNotification(UMOMessage resource, UMOImmutableEndpoint endpoint, String identifier, int action) {
        super(MessageNotification.cloneMessage(resource), action);
        this.resourceIdentifier = identifier;
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static UMOMessage cloneMessage(UMOMessage message) {
        UMOMessage uMOMessage = message;
        synchronized (uMOMessage) {
            return new MuleMessage(message.getPayload(), message);
        }
    }

    protected String getPayloadToString() {
        if (this.source instanceof UMOConnectable) {
            return ((UMOConnectable)this.source).getConnectionDescription();
        }
        return this.source.toString();
    }

    public String toString() {
        return this.EVENT_NAME + "{action=" + MessageNotification.getActionName(this.action) + ", endpoint: " + this.endpoint.getEndpointURI() + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    static {
        MessageNotification.registerAction("received", 801);
        MessageNotification.registerAction("dispatched", 802);
        MessageNotification.registerAction("sent", 803);
        MessageNotification.registerAction("requested", 804);
    }
}

