/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.ConfigurationBuilder;
import org.mule.impl.AbstractAgent;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;

public class ConfigScannerAgent
extends AbstractAgent {
    public static final String AGENT_NAME = "Mule Config Scanner";
    protected static Log logger = LogFactory.getLog((Class)ConfigScannerAgent.class);
    private String configDirName = null;
    private File configDir = null;
    private int sleepInterval = 5000;
    private boolean doStop = false;
    private ScannerThread scannerThread = null;

    public ConfigScannerAgent() {
        super(AGENT_NAME);
    }

    public String getConfigDirName() {
        return this.configDirName;
    }

    public void setConfigDirName(String configDirName) {
        this.configDirName = configDirName;
    }

    public String getDescription() {
        return this.getName() + " scanning for files in " + this.configDirName;
    }

    public void start() throws UMOException {
        this.scannerThread = new ScannerThread();
        this.scannerThread.start();
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        if (this.configDirName == null) {
            String workDir = RegistryContext.getConfiguration().getWorkingDirectory();
            this.configDirName = workDir + "/conf";
        }
        try {
            this.configDir = FileUtils.openDirectory(this.configDirName);
        }
        catch (IOException ioe) {
            throw new InitialisationException((Throwable)ioe, (Initialisable)this);
        }
    }

    public String toString() {
        return this.getDescription();
    }

    public void setDoStop(boolean doStop) {
        this.doStop = doStop;
    }

    private void processConfigFile(String configFile) {
        try {
            Class cfgBuilderClass = ClassUtils.loadClass("org.mule.config.builders.MuleXmlConfigurationBuilder", MuleServer.class);
            ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)cfgBuilderClass.newInstance();
            if (!cfgBuilder.isConfigured()) {
                cfgBuilder.configure(configFile);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    class ScannerThread
    extends Thread {
        int errorCount = 0;
        int errorThreshold = 3;
        List processedFiles = new ArrayList();

        ScannerThread() {
        }

        public void run() {
            while (!ConfigScannerAgent.this.doStop && this.errorCount < this.errorThreshold) {
                try {
                    File[] configFiles = ConfigScannerAgent.this.configDir.listFiles();
                    for (int i = 0; i < configFiles.length; ++i) {
                        File configFile = configFiles[i];
                        String path = configFile.getCanonicalPath();
                        if (this.processedFiles.contains(path)) {
                            configFile.delete();
                            if (!configFile.exists()) continue;
                            this.processedFiles.remove(this.processedFiles.indexOf(path));
                            continue;
                        }
                        logger.info((Object)path);
                        ConfigScannerAgent.this.processConfigFile(path);
                        configFile.delete();
                        this.processedFiles.add(path);
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)("Unable to check directory: " + ioe.toString()));
                    ++this.errorCount;
                }
                try {
                    ScannerThread.sleep(ConfigScannerAgent.this.sleepInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

