/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import javax.naming.NamingException;
import org.mule.impl.container.JndiContainerContext;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.ClassUtils;

public class RmiContainerContext
extends JndiContainerContext {
    protected String securityPolicy = null;
    protected String securityManager = null;

    protected RmiContainerContext(String name) {
        super(name);
    }

    public RmiContainerContext() {
        super("rmi");
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.securityPolicy != null && ClassUtils.getResource(this.securityPolicy, this.getClass()) != null) {
            System.setProperty("java.security.policy", this.securityPolicy);
        }
        if (System.getSecurityManager() == null) {
            try {
                if (this.securityManager != null) {
                    Class clazz = ClassUtils.loadClass(this.securityManager, this.getClass());
                    System.setSecurityManager((SecurityManager)clazz.newInstance());
                }
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        Object object = null;
        if (key == null) {
            throw new ObjectNotFoundException("null");
        }
        try {
            object = this.context.lookup(key.toString());
        }
        catch (NamingException e) {
            throw new ObjectNotFoundException(key.toString(), (Throwable)e);
        }
        if (object == null) {
            throw new ObjectNotFoundException(key.toString());
        }
        return object;
    }

    public String getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(String securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public String getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(String securityManager) {
        this.securityManager = securityManager;
    }
}

