/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.DefaultMessageAdapter;
import org.mule.providers.NullPayload;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.PropertyScope;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMutableMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.DebugOptions;

public class MuleMessage
implements UMOMessage,
ThreadSafeAccess {
    private static final long serialVersionUID = 1541720810851984842L;
    private static Log logger = LogFactory.getLog((Class)MuleMessage.class);
    private UMOMessageAdapter adapter;
    private UMOMessageAdapter originalAdapter = null;
    private transient List appliedTransformerHashCodes = new CopyOnWriteArrayList();
    private byte[] cache;

    public MuleMessage(Object message) {
        this(message, (Map)null);
    }

    public MuleMessage(Object message, Map properties) {
        this.adapter = message instanceof UMOMessageAdapter ? (UMOMessageAdapter)message : new DefaultMessageAdapter(message);
        this.addProperties(properties);
        this.resetAccessControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleMessage(Object message, UMOMessageAdapter previous) {
        if (message instanceof UMOMessageAdapter) {
            this.adapter = (UMOMessageAdapter)message;
            ((ThreadSafeAccess)((Object)this.adapter)).resetAccessControl();
        } else {
            this.adapter = new DefaultMessageAdapter(message, previous);
        }
        if (previous.getExceptionPayload() != null) {
            this.setExceptionPayload(previous.getExceptionPayload());
        }
        this.setEncoding(previous.getEncoding());
        if (previous.getAttachmentNames().size() > 0) {
            Set attNames;
            Set set = attNames = this.adapter.getAttachmentNames();
            synchronized (set) {
                Iterator iterator = attNames.iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    try {
                        this.addAttachment(s, this.adapter.getAttachment(s));
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException(CoreMessages.failedToReadAttachment(s), (Throwable)e);
                    }
                }
            }
        }
        this.resetAccessControl();
    }

    public Object getPayload(Class outputType) throws TransformerException {
        return this.getPayload(outputType, this.getEncoding());
    }

    protected Object getPayload(Class outputType, String encoding) throws TransformerException {
        if (outputType == null) {
            return this.getPayload();
        }
        Class<?> inputCls = this.getPayload().getClass();
        if (Proxy.isProxyClass(inputCls)) {
            inputCls = inputCls.getInterfaces()[0];
        }
        if (outputType.isAssignableFrom(inputCls)) {
            return this.getPayload();
        }
        UMOTransformer transformer = null;
        transformer = RegistryContext.getRegistry().lookupTransformer(inputCls, outputType);
        if (transformer == null) {
            throw new TransformerException(CoreMessages.noTransformerFoundForMessage(inputCls, outputType));
        }
        Object result = transformer.transform(this);
        if (!outputType.isAssignableFrom(result.getClass())) {
            throw new TransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(outputType.getName(), result.getClass()));
        }
        if (this.isPayloadConsumed(inputCls)) {
            this.setPayload(result);
        }
        return result;
    }

    protected boolean isPayloadConsumed(Class inputCls) {
        return InputStream.class.isAssignableFrom(inputCls);
    }

    public UMOMessageAdapter getAdapter() {
        return this.adapter;
    }

    public Object getOrginalPayload() {
        return this.originalAdapter == null ? this.adapter.getPayload() : this.originalAdapter.getPayload();
    }

    public UMOMessageAdapter getOriginalAdapter() {
        return this.originalAdapter == null ? this.adapter : this.originalAdapter;
    }

    public void setProperty(String key, Object value, PropertyScope scope) {
        this.adapter.setProperty(key, value, scope);
    }

    public Object getProperty(String key) {
        return this.adapter.getProperty(key);
    }

    public Object removeProperty(String key) {
        return this.adapter.removeProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.adapter.setProperty(key, value);
    }

    public final String getPayloadAsString() throws Exception {
        this.assertAccess(false);
        return this.getPayloadAsString(this.getEncoding());
    }

    public byte[] getPayloadAsBytes() throws Exception {
        this.assertAccess(false);
        if (this.cache != null) {
            return this.cache;
        }
        byte[] result = (byte[])this.getPayload([B.class);
        if (DebugOptions.isCacheMessageAsBytes()) {
            this.cache = result;
        }
        return result;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        this.assertAccess(false);
        if (this.cache != null) {
            return new String(this.cache, encoding);
        }
        String result = (String)this.getPayload(String.class);
        if (DebugOptions.isCacheMessageAsBytes()) {
            this.cache = result.getBytes(encoding);
        }
        return result;
    }

    public Set getPropertyNames() {
        return this.adapter.getPropertyNames();
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.adapter.getDoubleProperty(name, defaultValue);
    }

    public void setDoubleProperty(String name, double value) {
        this.adapter.setDoubleProperty(name, value);
    }

    public String getUniqueId() {
        return this.adapter.getUniqueId();
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.adapter.getProperty(name, defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.adapter.getIntProperty(name, defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.adapter.getLongProperty(name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.adapter.getBooleanProperty(name, defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.adapter.setBooleanProperty(name, value);
    }

    public void setIntProperty(String name, int value) {
        this.adapter.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) {
        this.adapter.setLongProperty(name, value);
    }

    public void setCorrelationId(String id) {
        this.adapter.setCorrelationId(id);
    }

    public String getCorrelationId() {
        return this.adapter.getCorrelationId();
    }

    public void setReplyTo(Object replyTo) {
        this.adapter.setReplyTo(replyTo);
    }

    public Object getReplyTo() {
        return this.adapter.getReplyTo();
    }

    public int getCorrelationSequence() {
        return this.adapter.getCorrelationSequence();
    }

    public void setCorrelationSequence(int sequence) {
        this.adapter.setCorrelationSequence(sequence);
    }

    public int getCorrelationGroupSize() {
        return this.adapter.getCorrelationGroupSize();
    }

    public void setCorrelationGroupSize(int size) {
        this.adapter.setCorrelationGroupSize(size);
    }

    public UMOExceptionPayload getExceptionPayload() {
        return this.adapter.getExceptionPayload();
    }

    public void setExceptionPayload(UMOExceptionPayload exceptionPayload) {
        this.adapter.setExceptionPayload(exceptionPayload);
    }

    public String toString() {
        return this.adapter.toString();
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.adapter.addAttachment(name, dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        this.adapter.removeAttachment(name);
    }

    public DataHandler getAttachment(String name) {
        return this.adapter.getAttachment(name);
    }

    public Set getAttachmentNames() {
        return this.adapter.getAttachmentNames();
    }

    public String getEncoding() {
        return this.adapter.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.adapter.setEncoding(encoding);
    }

    public String getStringProperty(String name, String defaultValue) {
        return this.adapter.getStringProperty(name, defaultValue);
    }

    public void setStringProperty(String name, String value) {
        this.adapter.setStringProperty(name, value);
    }

    public void addProperties(Map properties) {
        this.adapter.addProperties(properties);
    }

    public void clearProperties() {
        this.adapter.clearProperties();
    }

    public Object getPayload() {
        return this.adapter.getPayload();
    }

    public synchronized void setPayload(Object payload) {
        if (!(this.adapter instanceof UMOMutableMessageAdapter)) {
            this.adapter = new DefaultMessageAdapter(payload, this.adapter);
        } else {
            ((UMOMutableMessageAdapter)this.adapter).setPayload(payload);
        }
        this.cache = null;
    }

    public void release() {
        this.adapter.release();
        if (this.originalAdapter != null) {
            this.originalAdapter.release();
        }
        this.cache = null;
        this.appliedTransformerHashCodes.clear();
    }

    public void applyTransformers(List transformers) throws TransformerException {
        this.applyTransformers(transformers, null);
    }

    public void applyTransformers(List transformers, Class outputType) throws TransformerException {
        if (TransformerUtils.isDefined(transformers) && transformers.size() > 0 && !this.appliedTransformerHashCodes.contains(new Integer(((Object)transformers).hashCode()))) {
            this.applyAllTransformers(transformers);
            this.appliedTransformerHashCodes.add(new Integer(((Object)transformers).hashCode()));
        }
        if (null != outputType && !this.getPayload().getClass().isAssignableFrom(outputType)) {
            this.setPayload(this.getPayload(outputType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyAllTransformers(List transformers) throws TransformerException {
        if (TransformerUtils.isDefined(transformers) && transformers.size() > 0) {
            Iterator iterator = transformers.iterator();
            while (iterator.hasNext()) {
                Class<?> srcCls;
                UMOTransformer transformer = (UMOTransformer)iterator.next();
                if (this.getPayload() == null) {
                    if (transformer.isAcceptNull()) {
                        this.setPayload(NullPayload.getInstance());
                    } else {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Transformer " + transformer + " doesn't support the null payload, exiting from transformer chain."));
                        break;
                    }
                }
                if (transformer.isSourceTypeSupported(srcCls = this.getPayload().getClass())) {
                    Object result = transformer.transform(this);
                    if (this.originalAdapter == null && DebugOptions.isCacheMessageOriginalPayload()) {
                        this.originalAdapter = this.adapter;
                    }
                    if (result instanceof UMOMessage) {
                        MuleMessage muleMessage = this;
                        synchronized (muleMessage) {
                            this.adapter = ((UMOMessage)result).getAdapter();
                            continue;
                        }
                    }
                    this.setPayload(result);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transformer " + transformer + " doesn't support the source payload: " + srcCls));
                }
                if (transformer.isIgnoreBadInput()) continue;
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"Exiting from transformer chain (ignoreBadInput = false)");
                break;
            }
        }
    }

    public ThreadSafeAccess newThreadCopy() {
        if (this.adapter instanceof ThreadSafeAccess) {
            logger.debug((Object)("new copy of message for " + Thread.currentThread()));
            return new MuleMessage((Object)((ThreadSafeAccess)((Object)this.adapter)).newThreadCopy(), this);
        }
        return this;
    }

    public void resetAccessControl() {
        if (this.adapter instanceof AbstractMessageAdapter) {
            ((AbstractMessageAdapter)this.adapter).resetAccessControl();
        }
    }

    public void assertAccess(boolean write) {
        if (this.adapter instanceof AbstractMessageAdapter) {
            ((AbstractMessageAdapter)this.adapter).assertAccess(write);
        }
    }
}

