/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.Directories;
import org.mule.impl.internal.notifications.ManagerNotification;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.impl.internal.notifications.manager.ServerNotificationManager;
import org.mule.management.stats.AllStatistics;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.lifecycle.FatalException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.store.UMOStore;
import org.mule.util.FileUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.queue.QueueManager;

public class ManagementContext
implements UMOManagementContext {
    private static transient Log logger = LogFactory.getLog((Class)ManagementContext.class);
    public static final String NOTIFICATION_MANAGER = "_muleNotificationManager";
    private MuleConfiguration config;
    private String id = null;
    private String clusterId = null;
    private String domain = null;
    private long startDate = 0L;
    private AllStatistics stats = new AllStatistics();
    private UMOSecurityManager securityManager;
    private UMOWorkManager workManager;
    private QueueManager queueManager;
    protected TransactionManager transactionManager;
    protected UMOLifecycleManager lifecycleManager;
    protected Directories directories;
    protected String systemName;

    public ManagementContext(UMOLifecycleManager lifecycleManager) {
        if (lifecycleManager == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("lifecycleManager").getMessage());
        }
        this.lifecycleManager = lifecycleManager;
        this.startDate = System.currentTimeMillis();
    }

    public void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.securityManager == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("securityManager").getMessage());
        }
        if (this.getNotificationManager() == null) {
            throw new NullPointerException(CoreMessages.objectIsNull(NOTIFICATION_MANAGER).getMessage());
        }
        if (this.queueManager == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("queueManager").getMessage());
        }
        if (this.workManager == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("workManager").getMessage());
        }
        this.config = RegistryContext.getConfiguration();
        if (this.config == null) {
            logger.info((Object)"A mule configuration object was not registered. Using default configuration");
            this.config = new MuleConfiguration();
        }
        try {
            this.setupIds();
            this.validateEncoding();
            this.validateOSEncoding();
            this.directories = new Directories(FileUtils.newFile(this.config.getWorkingDirectory()));
            this.workManager.start();
            this.getNotificationManager().start(this.workManager);
            this.fireNotification(new ManagerNotification((UMOManagementContext)this, 101));
            this.directories.createDirectories();
            this.lifecycleManager.firePhase(this, "initialise");
            this.fireNotification(new ManagerNotification((UMOManagementContext)this, 102));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void setupIds() throws InitialisationException {
        this.id = this.config.getId();
        this.clusterId = this.config.getClusterId();
        this.domain = this.config.getDomainId();
        if (this.id == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("Instance ID"), (Initialisable)this);
        }
        if (this.clusterId == null) {
            this.clusterId = CoreMessages.notClustered().getMessage();
        }
        if (this.domain == null) {
            try {
                this.domain = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        this.systemName = this.domain + "." + this.clusterId + "." + this.id;
    }

    public synchronized void start() throws UMOException {
        this.lifecycleManager.checkPhase("start");
        if (!this.isStarted()) {
            this.fireNotification(new ManagerNotification((UMOManagementContext)this, 103));
            this.directories.deleteMarkedDirectories();
            this.lifecycleManager.firePhase(this, "start");
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.getStartSplash());
            }
            this.fireNotification(new ManagerNotification((UMOManagementContext)this, 104));
        }
    }

    public synchronized void stop() throws UMOException {
        this.lifecycleManager.checkPhase("stop");
        this.fireNotification(new ManagerNotification((UMOManagementContext)this, 105));
        this.lifecycleManager.firePhase(this, "stop");
        this.fireNotification(new ManagerNotification((UMOManagementContext)this, 106));
    }

    public void dispose() {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        this.lifecycleManager.checkPhase("dispose");
        this.fireNotification(new ManagerNotification((UMOManagementContext)this, 107));
        if (this.isDisposed()) {
            return;
        }
        try {
            if (this.isStarted()) {
                this.stop();
            }
        }
        catch (UMOException e) {
            logger.error((Object)("Failed to stop manager: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.lifecycleManager.firePhase(this, "dispose");
        }
        catch (UMOException e) {
            logger.debug((Object)("Failed to cleanly dispose Mule: " + e.getMessage()), (Throwable)e);
        }
        notificationManager.fireNotification(new ManagerNotification((UMOManagementContext)this, 108));
        if (this.startDate > 0L && logger.isInfoEnabled()) {
            logger.info((Object)this.getEndSplash());
        }
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    protected boolean isStopped() {
        return this.lifecycleManager.isPhaseComplete("stop");
    }

    protected boolean isStopping() {
        return "stop".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isStarted() {
        return this.lifecycleManager.isPhaseComplete("start");
    }

    protected boolean isStarting() {
        return "start".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    protected void validateEncoding() throws FatalException {
        String encoding = System.getProperty("org.mule.encoding");
        if (encoding == null) {
            encoding = this.config.getDefaultEncoding();
            System.setProperty("org.mule.encoding", encoding);
        } else {
            this.config.setDefaultEncoding(encoding);
        }
        if (!Charset.isSupported(this.config.getDefaultEncoding())) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("encoding", this.config.getDefaultEncoding()), (Object)this);
        }
    }

    protected void validateOSEncoding() throws FatalException {
        String encoding = System.getProperty("org.mule.osEncoding");
        if (encoding == null) {
            encoding = this.config.getDefaultOSEncoding();
            System.setProperty("org.mule.osEncoding", encoding);
        } else {
            this.config.setDefaultOSEncoding(encoding);
        }
        if (!Charset.isSupported(this.config.getDefaultOSEncoding())) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("osEncoding", this.config.getDefaultOSEncoding()), (Object)this);
        }
    }

    public UMOLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public UMOStore getStore(String name) throws UMOException {
        return null;
    }

    public UMOStore createStore(String name) throws UMOException {
        return null;
    }

    public void removeStore(UMOStore store) {
        store.dispose();
    }

    public long getStartDate() {
        return this.startDate;
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void setStatistics(AllStatistics stat) {
        this.stats = stat;
    }

    public Directories getDirectories() {
        return this.directories;
    }

    public void registerListener(UMOServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    public void registerListener(UMOServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    public void unregisterListener(UMOServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    public void fireNotification(UMOServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event Manager is not enabled, ignoring notification: " + notification));
        }
    }

    public void setId(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Management Context ID can't be null or empty");
        }
        this.checkLifecycleForPropertySet("id", "start");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.checkLifecycleForPropertySet("domain", "initialise");
        this.domain = domain;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.checkLifecycleForPropertySet("clusterId", "initialise");
        this.clusterId = clusterId;
    }

    public void setSecurityManager(UMOSecurityManager securityManager) throws InitialisationException {
        this.checkLifecycleForPropertySet("securityManager", "initialise");
        this.securityManager = securityManager;
    }

    public UMOSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(UMOWorkManager workManager) {
        this.checkLifecycleForPropertySet("workManager", "initialise");
        this.workManager = workManager;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.checkLifecycleForPropertySet("queueManager", "initialise");
        this.queueManager = queueManager;
    }

    public ServerNotificationManager getNotificationManager() {
        return (ServerNotificationManager)this.getRegistry().lookupObject(NOTIFICATION_MANAGER);
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) throws RegistrationException {
        this.checkLifecycleForPropertySet(NOTIFICATION_MANAGER, "initialise");
        this.getRegistry().registerObject(NOTIFICATION_MANAGER, notificationManager);
    }

    public void setTransactionManager(TransactionManager manager) throws Exception {
        this.transactionManager = manager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    private String getStartSplash() {
        String notset = CoreMessages.notSet().getMessage();
        ArrayList<String> message = new ArrayList<String>();
        Manifest mf = MuleManifest.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            message.add(StringUtils.defaultString((String)MuleManifest.getProductDescription(), (String)notset));
            message.add(CoreMessages.version().getMessage() + " Build: " + StringUtils.defaultString((String)MuleManifest.getBuildNumber(), (String)notset));
            message.add(StringUtils.defaultString((String)MuleManifest.getVendorName(), (String)notset));
            message.add(StringUtils.defaultString((String)MuleManifest.getProductMoreInfo(), (String)notset));
        } else {
            message.add(CoreMessages.versionNotSet().getMessage());
        }
        message.add(" ");
        message.add(CoreMessages.serverStartedAt(this.getStartDate()).getMessage());
        message.add("Server ID: " + this.id);
        message.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        String patch = System.getProperty("sun.os.patch.level", null);
        message.add("OS: " + System.getProperty("os.name") + (patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        try {
            InetAddress host = InetAddress.getLocalHost();
            message.add("Host: " + host.getHostName() + " (" + host.getHostAddress() + ")");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        message.add(" ");
        Collection agents = RegistryContext.getRegistry().getAgents();
        if (agents.size() == 0) {
            message.add(CoreMessages.agentsRunning().getMessage() + " " + CoreMessages.none().getMessage());
        } else {
            message.add(CoreMessages.agentsRunning().getMessage());
            Iterator iterator = agents.iterator();
            while (iterator.hasNext()) {
                UMOAgent umoAgent = (UMOAgent)iterator.next();
                message.add("  " + umoAgent.getDescription());
            }
        }
        return StringMessageUtils.getBoilerPlate(message, '*', 70);
    }

    private String getEndSplash() {
        ArrayList<String> message = new ArrayList<String>(2);
        long currentTime = System.currentTimeMillis();
        message.add(CoreMessages.shutdownNormally(new Date()).getMessage());
        long duration = 10L;
        if (this.startDate > 0L) {
            duration = currentTime - this.startDate;
        }
        message.add(CoreMessages.serverWasUpForDuration(duration).getMessage());
        return StringMessageUtils.getBoilerPlate(message, '*', 78);
    }

    public void register() throws RegistrationException {
        throw new UnsupportedOperationException("register");
    }

    public void deregister() throws RegistrationException {
        throw new UnsupportedOperationException("deregister");
    }

    public String getRegistryId() {
        throw new UnsupportedOperationException("registryId");
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has been gone through the " + phase + " phase.");
        }
    }

    public void setLifecycleManager(UMOLifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public Registry getRegistry() {
        return RegistryContext.getRegistry();
    }

    public void applyLifecycle(Object object) throws UMOException {
        this.lifecycleManager.applyLifecycle(this, object);
    }
}

