/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.FileUtils;

public class Directories {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String TEMP_DIR = "temp";
    public static final String BUNDLES_DIR = "bundles";
    public static final String INSTALL_DIR = "install";
    public static final String DEPLOY_DIR = "deploy";
    public static final String PROCESSED_DIR = "processed";
    public static final String WORKSPACE_DIR = "workspace";
    private static int counter;
    private File rootDir;

    public Directories(File rootDir) {
        this.rootDir = rootDir;
        this.createDirectory(rootDir);
    }

    public static synchronized File getNewTempDir(File rootDir) {
        String s;
        File f;
        do {
            s = Integer.toHexString(++counter);
            while (s.length() < 8) {
                s = "0" + s;
            }
        } while ((f = FileUtils.newFile(rootDir, File.separator + TEMP_DIR + File.separator + s)).exists());
        return f;
    }

    public File getBundleInstallDir(String name) {
        return FileUtils.newFile(this.rootDir, BUNDLES_DIR + File.separator + this.validateString(name));
    }

    public File getAutoInstallDir() {
        return FileUtils.newFile(this.rootDir, INSTALL_DIR);
    }

    public File getAutoInstallProcessedDir() {
        return FileUtils.newFile(this.rootDir, INSTALL_DIR + File.separator + PROCESSED_DIR);
    }

    public File getAutoDeployDir() {
        return FileUtils.newFile(this.rootDir, DEPLOY_DIR);
    }

    public File getAutoDeployProcessedDir() {
        return FileUtils.newFile(this.rootDir, DEPLOY_DIR + File.separator + PROCESSED_DIR);
    }

    public void deleteMarkedDirectories() {
        this.deleteMarkedDirectories(this.rootDir);
    }

    public void deleteMarkedDirectories(File rootDir) {
        if (rootDir != null && rootDir.isDirectory()) {
            if (FileUtils.newFile(rootDir, ".delete").isFile()) {
                this.deleteDirectory(rootDir);
            } else {
                File[] children = rootDir.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].isDirectory()) continue;
                    this.deleteMarkedDirectories(children[i]);
                }
            }
        }
    }

    public void deleteDirectory(String dir) {
        this.deleteDirectory(FileUtils.newFile(dir));
    }

    public void deleteDirectory(File dir) {
        FileUtils.deleteTree(dir);
        if (dir.isDirectory()) {
            try {
                FileUtils.newFile(dir, ".delete").createNewFile();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Could not mark directory to be deleted", (Throwable)e);
            }
        }
    }

    public void createDirectories() throws IOException {
        this.createDirectories(this.rootDir);
    }

    public void createDirectories(File rootDir) throws IOException {
        this.createDirectory(rootDir);
        this.createDirectory(FileUtils.newFile(rootDir, BUNDLES_DIR));
        this.createDirectory(FileUtils.newFile(rootDir, WORKSPACE_DIR));
        this.createDirectory(this.getAutoInstallDir());
        this.createDirectory(this.getAutoDeployDir());
        this.createDirectory(this.getAutoDeployProcessedDir());
    }

    public void createDirectory(File dir) {
        if (dir != null) {
            dir.mkdirs();
        }
    }

    private String validateString(String str) {
        str = str.replace(':', '_');
        str = str.replace('/', '_');
        str = str.replace('\\', '_');
        return str;
    }

    public File getWorkingDirectory() {
        return this.rootDir;
    }
}

