/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;

public class URIBuilder {
    private static final String DOTS = ":";
    private static final String DOTS_SLASHES = "://";
    private static final String QUERY = "?";
    private static final String AND = "&";
    private static final String EQUALS = "=";
    public static final String META = "meta";
    public static final String PROTOCOL = "protocol";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String HOST = "host";
    public static final String ADDRESS = "address";
    public static final String PORT = "port";
    public static final String PATH = "path";
    public static final String[] ALL_ATTRIBUTES = new String[]{"meta", "protocol", "user", "password", "host", "address", "port", "path"};
    public static final String[] PATH_ATTRIBUTES = new String[]{"path"};
    public static final String[] HOST_ATTRIBUTES = new String[]{"host"};
    public static final String[] SOCKET_ATTRIBUTES = new String[]{"host", "port"};
    public static final String[] USERHOST_ATTRIBUTES = new String[]{"user", "host"};
    public static final String[] ALL_TRANSPORT_ATTRIBUTES = new String[]{"user", "password", "host", "address", "port", "path"};
    private String address;
    private String meta;
    private String protocol;
    private String user;
    private String password;
    private String host;
    private Integer port;
    private String path;
    private Map queryMap;
    private AtomicReference cache = new AtomicReference();

    public URIBuilder() {
    }

    public URIBuilder(UMOEndpointURI endpointURI) {
        this.cache.set((Object)endpointURI);
    }

    public URIBuilder(String address) {
        int dots = address.indexOf(DOTS);
        int dotsSlashes = address.indexOf(DOTS_SLASHES);
        if (dots > -1 && dots < dotsSlashes) {
            this.meta = address.substring(0, dots);
            address = address.substring(dots + 1);
        }
        this.address = address;
    }

    public void setUser(String user) {
        this.assertNotUsed();
        this.user = user;
    }

    public void setPassword(String password) {
        this.assertNotUsed();
        this.password = password;
    }

    public void setHost(String host) {
        this.assertNotUsed();
        this.host = host;
    }

    public void setAddress(String address) {
        this.assertNotUsed();
        this.address = address;
        this.assertAddressConsistent();
    }

    public void setPort(int port) {
        this.assertNotUsed();
        this.port = new Integer(port);
    }

    public void setProtocol(String protocol) {
        this.assertNotUsed();
        this.protocol = protocol;
        this.assertAddressConsistent();
    }

    public void setMeta(String meta) {
        this.assertNotUsed();
        this.meta = meta;
    }

    public void setPath(String path) {
        this.assertNotUsed();
        if (null != path && path.indexOf(DOTS_SLASHES) > -1) {
            throw new IllegalArgumentException("Unusual syntax in path: '" + path + "' contains " + DOTS_SLASHES);
        }
        this.path = path;
    }

    public void setQueryMap(Map queryMap) {
        this.assertNotUsed();
        this.queryMap = queryMap;
    }

    public UMOEndpointURI getEndpoint() {
        if (null == this.cache.get()) {
            try {
                MuleEndpointURI endpointUri = new MuleEndpointURI(this.getConstructor());
                this.cache.compareAndSet(null, (Object)endpointUri);
            }
            catch (EndpointException e) {
                throw (IllegalStateException)new IllegalStateException("Bad endpoint configuration").initCause(e);
            }
        }
        return (UMOEndpointURI)this.cache.get();
    }

    protected String getConstructor() {
        StringBuffer buffer = new StringBuffer();
        this.appendMeta(buffer);
        this.appendAddress(buffer);
        this.appendQueries(buffer);
        return buffer.toString();
    }

    private void appendMeta(StringBuffer buffer) {
        if (null != this.meta) {
            buffer.append(this.meta);
            buffer.append(DOTS);
        }
    }

    private void appendAddress(StringBuffer buffer) {
        if (null != this.address) {
            buffer.append(this.address);
        } else {
            this.constructAddress(buffer);
        }
    }

    private void constructAddress(StringBuffer buffer) {
        buffer.append(this.protocol);
        buffer.append(DOTS_SLASHES);
        boolean atStart = true;
        if (null != this.user) {
            buffer.append(this.user);
            if (null != this.password) {
                buffer.append(DOTS);
                buffer.append(this.password);
            }
            buffer.append("@");
            atStart = false;
        }
        if (null != this.host) {
            buffer.append(this.host);
            if (null != this.port) {
                buffer.append(DOTS);
                buffer.append(this.port);
            }
            atStart = false;
        }
        if (null != this.path) {
            if (!atStart) {
                buffer.append("/");
            }
            buffer.append(this.path);
        }
    }

    private void appendQueries(StringBuffer buffer) {
        if (null != this.queryMap) {
            boolean first = buffer.indexOf(QUERY) == -1;
            Iterator keys = new TreeSet(this.queryMap.keySet()).iterator();
            while (keys.hasNext()) {
                if (first) {
                    buffer.append(QUERY);
                    first = false;
                } else {
                    buffer.append(AND);
                }
                String key = (String)keys.next();
                buffer.append(key);
                buffer.append(EQUALS);
                buffer.append((String)this.queryMap.get(key));
            }
        }
    }

    protected void assertNotUsed() {
        if (null != this.cache.get()) {
            throw new IllegalStateException("Too late to set values - builder already used");
        }
    }

    protected void assertAddressConsistent() {
        if (null != this.meta) {
            if (null != this.address) {
                if (this.address.startsWith(this.meta + DOTS)) {
                    throw new IllegalArgumentException("Meta-protocol '" + this.meta + "' should not be specified in the address '" + this.address + "' - it is implicit in the element namespace.");
                }
                if (null != this.protocol) {
                    this.assertProtocolConsistent();
                } else if (this.address.indexOf(DOTS_SLASHES) == -1) {
                    throw new IllegalArgumentException("Address '" + this.address + "' does not have a transport protocol prefix " + "(omit the meta protocol prefix, '" + this.meta + DOTS + "' - it is implicit in the element namespace).");
                }
            }
        } else {
            this.assertProtocolConsistent();
        }
    }

    protected void assertProtocolConsistent() {
        if (null != this.protocol && null != this.address && !this.address.startsWith(this.protocol + DOTS_SLASHES)) {
            throw new IllegalArgumentException("Address '" + this.address + "' for protocol '" + this.protocol + "' should start with " + this.protocol + DOTS_SLASHES);
        }
    }

    public String toString() {
        return this.getConstructor();
    }
}

