/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.util.StringUtils;
import org.mule.util.object.PooledObjectFactory;
import org.mule.util.object.SimpleObjectFactory;
import org.mule.util.object.SingletonObjectFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ObjectFactoryDefinitionParser
extends ChildDefinitionParser {
    public static final String FACTORY_REF = "factory-ref";
    protected Class beanClass = null;

    public ObjectFactoryDefinitionParser(Class beanClass, String setterMethod) {
        this(setterMethod);
        this.beanClass = beanClass;
    }

    public ObjectFactoryDefinitionParser(String setterMethod) {
        super(setterMethod, null);
        this.setAllowClassAttribute(false);
        this.addAlias("class", "objectClassName");
    }

    protected Class getBeanClass(Element element) {
        if (this.beanClass != null) {
            return this.beanClass;
        }
        String scope = element.getAttribute("scope");
        if (StringUtils.isBlank((String)scope)) {
            scope = "prototype";
        }
        element.removeAttribute("scope");
        if (scope.equals("prototype")) {
            return SimpleObjectFactory.class;
        }
        if (scope.equals("singleton")) {
            return SingletonObjectFactory.class;
        }
        if (scope.equals("pooled")) {
            return PooledObjectFactory.class;
        }
        this.logger.error((Object)("Scope " + scope + " not recognized."));
        return null;
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Attr factory = element.getAttributeNode(FACTORY_REF);
        if (null != factory) {
            this.getBeanAssembler(element, builder).extendTarget(factory);
            element.removeAttributeNode(factory);
        } else {
            super.parseChild(element, parserContext, builder);
        }
    }
}

