/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.util.HashMap;
import java.util.Map;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.config.spring.parsers.processors.CheckRequiredAttributes;
import org.mule.impl.internal.notifications.AdminNotification;
import org.mule.impl.internal.notifications.AdminNotificationListener;
import org.mule.impl.internal.notifications.ComponentNotification;
import org.mule.impl.internal.notifications.ComponentNotificationListener;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.impl.internal.notifications.CustomNotification;
import org.mule.impl.internal.notifications.CustomNotificationListener;
import org.mule.impl.internal.notifications.ExceptionNotification;
import org.mule.impl.internal.notifications.ExceptionNotificationListener;
import org.mule.impl.internal.notifications.ManagementNotification;
import org.mule.impl.internal.notifications.ManagementNotificationListener;
import org.mule.impl.internal.notifications.ManagerNotification;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.MessageNotification;
import org.mule.impl.internal.notifications.MessageNotificationListener;
import org.mule.impl.internal.notifications.ModelNotification;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.impl.internal.notifications.RegistryNotification;
import org.mule.impl.internal.notifications.RegistryNotificationListener;
import org.mule.impl.internal.notifications.SecurityNotification;
import org.mule.impl.internal.notifications.SecurityNotificationListener;
import org.mule.impl.internal.notifications.TransactionNotification;
import org.mule.impl.internal.notifications.TransactionNotificationListener;
import org.w3c.dom.Element;

public class NotificationDefinitionParser
extends ChildMapEntryDefinitionParser {
    public static final Map EVENT_MAP;
    public static final Map INTERFACE_MAP;
    public static final String INTERFACE = "interface";
    public static final String INTERFACE_CLASS = "interface-class";
    public static final String EVENT = "event";
    public static final String EVENT_CLASS = "event-class";
    public static final String[][] INTERFACE_ATTRIBUTES;
    public static final String[][] EVENT_ATTRIBUTES;
    public static final String[][] ALL_ATTRIBUTES;

    public NotificationDefinitionParser() {
        super("interfaceToType", INTERFACE_CLASS, EVENT_CLASS);
        this.addMapping(EVENT, EVENT_MAP);
        this.addAlias(EVENT, "value");
        this.addMapping(INTERFACE, INTERFACE_MAP);
        this.addAlias(INTERFACE, "key");
        this.registerPreProcessor(new CheckExclusiveAttributes(INTERFACE_ATTRIBUTES));
        this.registerPreProcessor(new CheckExclusiveAttributes(EVENT_ATTRIBUTES));
        this.registerPreProcessor(new CheckRequiredAttributes(INTERFACE_ATTRIBUTES));
        this.registerPreProcessor(new CheckRequiredAttributes(EVENT_ATTRIBUTES));
        this.registerPreProcessor(new SetDefaults());
    }

    static {
        INTERFACE_ATTRIBUTES = new String[][]{{INTERFACE}, {INTERFACE_CLASS}};
        EVENT_ATTRIBUTES = new String[][]{{EVENT}, {EVENT_CLASS}};
        ALL_ATTRIBUTES = new String[][]{{EVENT}, {EVENT_CLASS}, {INTERFACE}, {INTERFACE_CLASS}};
        EVENT_MAP = new HashMap();
        EVENT_MAP.put("MANAGER", ManagerNotification.class.getName());
        EVENT_MAP.put("MODEL", ModelNotification.class.getName());
        EVENT_MAP.put("COMPONENT", ComponentNotification.class.getName());
        EVENT_MAP.put("SECURITY", SecurityNotification.class.getName());
        EVENT_MAP.put("MANAGEMENT", ManagementNotification.class.getName());
        EVENT_MAP.put("ADMIN", AdminNotification.class.getName());
        EVENT_MAP.put("CONNECTION", ConnectionNotification.class.getName());
        EVENT_MAP.put("REGISTRY", RegistryNotification.class.getName());
        EVENT_MAP.put("CUSTOM", CustomNotification.class.getName());
        EVENT_MAP.put("MESSAGE", MessageNotification.class.getName());
        EVENT_MAP.put("EXCEPTION", ExceptionNotification.class.getName());
        EVENT_MAP.put("TRANSACTION", TransactionNotification.class.getName());
        INTERFACE_MAP = new HashMap();
        INTERFACE_MAP.put("MANAGER", ManagerNotificationListener.class.getName());
        INTERFACE_MAP.put("MODEL", ModelNotificationListener.class.getName());
        INTERFACE_MAP.put("COMPONENT", ComponentNotificationListener.class.getName());
        INTERFACE_MAP.put("SECURITY", SecurityNotificationListener.class.getName());
        INTERFACE_MAP.put("MANAGEMENT", ManagementNotificationListener.class.getName());
        INTERFACE_MAP.put("ADMIN", AdminNotificationListener.class.getName());
        INTERFACE_MAP.put("CONNECTION", ConnectionNotificationListener.class.getName());
        INTERFACE_MAP.put("REGISTRY", RegistryNotificationListener.class.getName());
        INTERFACE_MAP.put("CUSTOM", CustomNotificationListener.class.getName());
        INTERFACE_MAP.put("MESSAGE", MessageNotificationListener.class.getName());
        INTERFACE_MAP.put("EXCEPTION", ExceptionNotificationListener.class.getName());
        INTERFACE_MAP.put("TRANSACTION", TransactionNotificationListener.class.getName());
    }

    private class SetDefaults
    implements PreProcessor {
        private SetDefaults() {
        }

        public void preProcess(PropertyConfiguration config, Element element) {
            this.copy(element, NotificationDefinitionParser.INTERFACE, NotificationDefinitionParser.EVENT, NotificationDefinitionParser.EVENT_CLASS);
            this.copy(element, NotificationDefinitionParser.EVENT, NotificationDefinitionParser.INTERFACE, NotificationDefinitionParser.INTERFACE_CLASS);
        }

        private void copy(Element element, String from, String to, String blocker) {
            if (element.hasAttribute(from) && !element.hasAttribute(to) && !element.hasAttribute(blocker)) {
                element.setAttribute(to, element.getAttribute(from));
            }
        }
    }
}

