/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.util.CoreXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class CheckExclusiveClassAttributeObjectFactory
implements PreProcessor {
    private static final String BINDING_CHILD_ELEMENT = "binding";

    CheckExclusiveClassAttributeObjectFactory() {
    }

    public void preProcess(PropertyConfiguration config, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String alias = CoreXMLUtils.attributeName((Attr)attributes.item(i));
            if (!alias.equals("class")) continue;
            for (int j = 0; j < element.getChildNodes().getLength(); ++j) {
                Node child = element.getChildNodes().item(j);
                if (!(child instanceof Element) || child.getLocalName().equals(BINDING_CHILD_ELEMENT)) continue;
                StringBuffer message = new StringBuffer("The child element '");
                message.append(child.getLocalName());
                message.append("' cannot appear with the 'class' attrtibute");
                message.append(" in element ");
                message.append(CoreXMLUtils.elementToString(element));
                message.append(".");
                throw new CheckExclusiveClassAttributeObjectFactoryException(message.toString());
            }
        }
    }

    public static class CheckExclusiveClassAttributeObjectFactoryException
    extends IllegalStateException {
        private static final long serialVersionUID = 4625276914151932111L;

        private CheckExclusiveClassAttributeObjectFactoryException(String message) {
            super(message);
        }
    }
}

