/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.delegate;

import java.util.HashMap;
import java.util.Map;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.delegate.AbstractParallelDelegatingDefinitionParser;
import org.mule.util.CollectionUtils;
import org.mule.util.CoreXMLUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AttributeSelectionDefinitionParser
extends AbstractParallelDelegatingDefinitionParser {
    private Map attributeToParserIndex = new HashMap();

    public AttributeSelectionDefinitionParser(String attribute, MuleDefinitionParser delegate) {
        this.addDelegate(attribute, delegate);
    }

    public void addDelegate(String attribute, MuleDefinitionParser delegate) {
        this.addDelegate(delegate);
        this.attributeToParserIndex.put(attribute, new Integer(this.size() - 1));
        delegate.setIgnoredDefault(true);
        delegate.removeIgnored(attribute);
    }

    protected MuleDefinitionParser getDelegate(Element element, ParserContext parserContext) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attribute = CoreXMLUtils.attributeName((Attr)attributes.item(i));
            if (!this.attributeToParserIndex.containsKey(attribute)) continue;
            return this.getDelegate((Integer)this.attributeToParserIndex.get(attribute));
        }
        throw new IllegalArgumentException("Element " + CoreXMLUtils.elementToString(element) + " does not contain any attribute from " + CollectionUtils.toString(this.attributeToParserIndex.keySet(), 10, false));
    }
}

