/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.delegate;

import java.util.Map;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.PostProcessor;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.SimplePropertyConfiguration;
import org.mule.config.spring.parsers.collection.DynamicAttributeDefinitionParser;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.util.CoreXMLUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AllAttributeChildDefinitionParser
extends AbstractBeanDefinitionParser
implements MuleDefinitionParser {
    private DynamicAttributeDefinitionParser delegate;
    private PropertyConfiguration configuration = new SimplePropertyConfiguration();

    public AllAttributeChildDefinitionParser(DynamicAttributeDefinitionParser delegate) {
        this.addIgnored("id");
        this.addIgnored("name");
        this.delegate = delegate;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = CoreXMLUtils.attributeName((Attr)attributes.item(i));
            if (this.isIgnored(name)) continue;
            this.delegate.setAttributeName(name);
            this.delegate.parseDelegate(element, parserContext);
        }
        return null;
    }

    public AbstractBeanDefinition parseDelegate(Element element, ParserContext parserContext) {
        return this.parseInternal(element, parserContext);
    }

    public void registerPreProcessor(PreProcessor preProcessor) {
        this.delegate.registerPreProcessor(preProcessor);
    }

    public void registerPostProcessor(PostProcessor postProcessor) {
        this.delegate.registerPostProcessor(postProcessor);
    }

    public MuleDefinitionParser addReference(String propertyName) {
        this.configuration.addReference(propertyName);
        return this;
    }

    public MuleDefinitionParser addMapping(String propertyName, Map mappings) {
        this.configuration.addMapping(propertyName, mappings);
        return this;
    }

    public MuleDefinitionParser addMapping(String propertyName, String mappings) {
        this.configuration.addMapping(propertyName, mappings);
        return this;
    }

    public MuleDefinitionParser addAlias(String alias, String propertyName) {
        this.configuration.addAlias(alias, propertyName);
        return this;
    }

    public MuleDefinitionParser addCollection(String propertyName) {
        this.configuration.addCollection(propertyName);
        return this;
    }

    public MuleDefinitionParser addIgnored(String propertyName) {
        this.configuration.addIgnored(propertyName);
        return this;
    }

    public MuleDefinitionParser removeIgnored(String propertyName) {
        this.configuration.removeIgnored(propertyName);
        return this;
    }

    public MuleDefinitionParser setIgnoredDefault(boolean ignoreAll) {
        this.configuration.setIgnoredDefault(ignoreAll);
        return this;
    }

    public String getAttributeMapping(String alias) {
        return this.configuration.getAttributeMapping(alias);
    }

    public boolean isCollection(String propertyName) {
        return this.configuration.isCollection(propertyName);
    }

    public boolean isIgnored(String propertyName) {
        return this.configuration.isIgnored(propertyName);
    }

    public boolean isBeanReference(String attributeName) {
        return this.configuration.isReference(attributeName);
    }

    public String translateName(String oldName) {
        return this.configuration.translateName(oldName);
    }

    public String translateValue(String name, String value) {
        return this.configuration.translateValue(name, value);
    }

    public String getBeanName(Element element) {
        return AutoIdUtils.getUniqueName(element, "all-attribute");
    }
}

