/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.assembly;

import java.util.Map;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.SimplePropertyConfiguration;
import org.mule.config.spring.parsers.assembly.SingleProperty;
import org.mule.config.spring.parsers.assembly.SinglePropertyWrapper;
import org.mule.config.spring.parsers.assembly.TempWrapperPropertyConfiguration;

public class ReusablePropertyConfiguration
implements PropertyConfiguration {
    private PropertyConfiguration reference;
    private PropertyConfiguration delegate;

    public ReusablePropertyConfiguration() {
        this(new SimplePropertyConfiguration());
    }

    public ReusablePropertyConfiguration(PropertyConfiguration delegate) {
        this.delegate = delegate;
    }

    public void reset() {
        if (null == this.reference) {
            this.reference = this.delegate;
        }
        this.delegate = new TempWrapperPropertyConfiguration(this.reference);
    }

    public void addReference(String propertyName) {
        this.delegate.addReference(propertyName);
    }

    public void addMapping(String propertyName, Map mappings) {
        this.delegate.addMapping(propertyName, mappings);
    }

    public void addMapping(String propertyName, String mappings) {
        this.delegate.addMapping(propertyName, mappings);
    }

    public void addAlias(String alias, String propertyName) {
        this.delegate.addAlias(alias, propertyName);
    }

    public void addCollection(String propertyName) {
        this.delegate.addCollection(propertyName);
    }

    public void addIgnored(String propertyName) {
        this.delegate.addIgnored(propertyName);
    }

    public void removeIgnored(String propertyName) {
        this.delegate.removeIgnored(propertyName);
    }

    public void setIgnoredDefault(boolean ignoreAll) {
        this.delegate.setIgnoredDefault(ignoreAll);
    }

    public String getAttributeMapping(String alias) {
        return this.delegate.getAttributeMapping(alias);
    }

    public boolean isCollection(String propertyName) {
        return this.delegate.isCollection(propertyName);
    }

    public boolean isIgnored(String propertyName) {
        return this.delegate.isIgnored(propertyName);
    }

    public boolean isReference(String attributeName) {
        return this.delegate.isReference(attributeName);
    }

    public SingleProperty getSingleProperty(String propertyName) {
        return new SinglePropertyWrapper(propertyName, this);
    }

    public String translateName(String oldName) {
        return this.delegate.translateName(oldName);
    }

    public String translateValue(String name, String value) {
        return this.delegate.translateValue(name, value);
    }
}

