/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.RegistryContext;
import org.mule.impl.ManagementContextAware;
import org.mule.impl.model.ModelFactory;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.model.UMOModel;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class SystemModelFactoryBean
extends AbstractFactoryBean
implements ManagementContextAware {
    private String type;
    private UMOModel model;
    private UMOManagementContext managementContext;

    public Class getObjectType() {
        return UMOModel.class;
    }

    protected Object createInstance() throws Exception {
        if (RegistryContext.getRegistry() != null && RegistryContext.getRegistry().getConfiguration() != null) {
            this.type = RegistryContext.getRegistry().getConfiguration().getSystemModelType();
        }
        if (this.type == null) {
            this.type = "seda";
        }
        this.model = ModelFactory.createModel(this.type);
        this.model.setName("_muleSystemModel");
        this.model.setManagementContext(this.managementContext);
        return this.model;
    }

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.model.initialise();
    }

    public void destroy() throws Exception {
        super.destroy();
        this.model.dispose();
    }
}

